/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.config.spring.k8s;

import com.predic8.membrane.core.config.spring.K8sHelperGeneratorAutoGenerated;
import com.predic8.membrane.core.config.spring.k8s.YamlLoader;
import com.predic8.membrane.core.kubernetes.BeanRegistry;
import com.predic8.membrane.core.kubernetes.GenericYamlParser;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.events.MappingEndEvent;
import org.yaml.snakeyaml.events.MappingStartEvent;
import org.yaml.snakeyaml.events.ScalarEvent;

public class Envelope {
    String kind;
    String apiVersion;
    Metadata metadata;
    Object spec;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public void parse(Iterator<Event> events, BeanRegistry registry) {
        int state = 0;
        while (events.hasNext()) {
            Event event = events.next();
            block0 : switch (state) {
                case 0: {
                    if (!(event instanceof MappingStartEvent)) break;
                    state = 1;
                    break;
                }
                case 1: {
                    if (event instanceof ScalarEvent) {
                        String value;
                        switch (value = ((ScalarEvent)event).getValue()) {
                            case "kind": {
                                this.kind = YamlLoader.readString(events);
                                break block0;
                            }
                            case "apiVersion": {
                                this.apiVersion = YamlLoader.readString(events);
                                break block0;
                            }
                            case "spec": {
                                this.spec = this.readSpec(this.kind, events, registry);
                                break block0;
                            }
                            case "metadata": {
                                this.metadata = this.readMetadata(events);
                                break block0;
                            }
                        }
                        this.additionalProperties.put(value, YamlLoader.readObj(events));
                        break;
                    }
                    if (event instanceof MappingEndEvent) {
                        return;
                    }
                    throw new IllegalStateException("Expected scalar or end-of-map in line " + event.getStartMark().getLine() + " column " + event.getStartMark().getColumn());
                }
            }
        }
    }

    private Object readSpec(String kind, Iterator<Event> events, BeanRegistry registry) {
        Class<?> clazz = K8sHelperGeneratorAutoGenerated.elementMapping.get(kind);
        if (clazz == null) {
            throw new RuntimeException("Did not find java class for kind '" + kind + "'.");
        }
        Object o = GenericYamlParser.parse(kind, clazz, events, registry);
        return o;
    }

    private Metadata readMetadata(Iterator<Event> events) {
        Event event = events.next();
        if (!(event instanceof MappingStartEvent)) {
            throw new IllegalStateException("Expected map in line " + event.getStartMark().getLine() + " column " + event.getStartMark().getColumn());
        }
        Metadata metadata = new Metadata();
        block10: while (events.hasNext()) {
            event = events.next();
            if (event instanceof ScalarEvent) {
                String value;
                switch (value = ((ScalarEvent)event).getValue()) {
                    case "name": {
                        metadata.name = YamlLoader.readString(events);
                        continue block10;
                    }
                    case "namespace": {
                        metadata.namespace = YamlLoader.readString(events);
                        continue block10;
                    }
                    case "uid": {
                        metadata.uid = YamlLoader.readString(events);
                        continue block10;
                    }
                }
                metadata.additionalProperties.put(value, YamlLoader.readObj(events));
                continue;
            }
            if (event instanceof MappingEndEvent) break;
            throw new IllegalStateException("Expected scalar or end-of-map in line " + event.getStartMark().getLine() + " column " + event.getStartMark().getColumn());
        }
        return metadata;
    }

    public Object getSpec() {
        return this.spec;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public static class Metadata {
        String name;
        String namespace;
        String uid;
        Map additionalProperties = new HashMap();

        public String getUid() {
            return this.uid;
        }
    }
}

