/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.exceptions;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.util.ExceptionUtil;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ProblemDetails {
    private static final Logger log = LoggerFactory.getLogger((String)ProblemDetails.class.getName());
    private static final ObjectMapper om = new ObjectMapper();
    private static final ObjectWriter ow = om.writerWithDefaultPrettyPrinter();
    private boolean production;
    private int statusCode;
    private String type;
    private String subType = "";
    private String title;
    private String detail;
    private Interceptor.Flow flow;
    private String seeSuffix = "";
    private String component;
    private final HashMap<String, Object> internalFields = new LinkedHashMap<String, Object>();
    private final HashMap<String, Object> topLevel = new LinkedHashMap<String, Object>();
    private Throwable exception;
    private boolean stacktrace = true;

    public static ProblemDetails user(boolean production, String component) {
        return ProblemDetails.problemDetails("user", production).statusCode(400).title("User error.").component(component);
    }

    public static ProblemDetails internal(boolean production, String component) {
        return ProblemDetails.problemDetails("internal", production).statusCode(500).title("Internal server error.").component(component);
    }

    public static ProblemDetails gateway(boolean production, String component) {
        return ProblemDetails.problemDetails("gateway", production).statusCode(500).title("Gateway error.").component(component);
    }

    public static ProblemDetails security(boolean production, String component) {
        return ProblemDetails.problemDetails("security", production).statusCode(500).title("Security error.").component(component);
    }

    public static ProblemDetails openapi(boolean production, String component) {
        return ProblemDetails.problemDetails("openapi", production).statusCode(400).title("OpenAPI error.").component(component);
    }

    public static ProblemDetails problemDetails(String type, boolean production) {
        ProblemDetails pd = new ProblemDetails();
        pd.type = type;
        pd.production = production;
        return pd;
    }

    public ProblemDetails addSubType(String subType) {
        this.subType = this.subType + "/" + subType;
        return this;
    }

    public ProblemDetails statusCode(int statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    public ProblemDetails title(String title) {
        this.title = title;
        return this;
    }

    public ProblemDetails detail(String humanReadableExplanation) {
        if (humanReadableExplanation != null) {
            this.detail = humanReadableExplanation;
        }
        return this;
    }

    public ProblemDetails component(String component) {
        this.component = component;
        return this;
    }

    public ProblemDetails flow(Interceptor.Flow flow) {
        this.flow = flow;
        return this;
    }

    public ProblemDetails addSubSee(String s) {
        this.seeSuffix = this.seeSuffix + s;
        return this;
    }

    public ProblemDetails internal(String key, Object value) {
        this.internalFields.put(key, value);
        return this;
    }

    public ProblemDetails topLevel(String key, Object value) {
        this.topLevel.put(key, value);
        return this;
    }

    public ProblemDetails exception(Throwable e) {
        this.exception = e;
        return this;
    }

    public ProblemDetails stacktrace(boolean stacktrace) {
        this.stacktrace = stacktrace;
        return this;
    }

    public Response build() {
        return this.createContent(this.createMap(), null);
    }

    public void buildAndSetResponse(Exchange exchange) {
        exchange.setResponse(this.createContent(this.createMap(), exchange));
    }

    @NotNull
    private Map<String, Object> createMap() {
        LinkedHashMap<String, Object> root = new LinkedHashMap<String, Object>();
        Map<String, Object> internalMap = new LinkedHashMap<String, Object>();
        root.put("title", this.title);
        String type = "https://membrane-api.io/problems/" + this.type;
        if (!this.subType.isEmpty()) {
            type = type + this.subType;
        }
        root.put("type", type);
        if (this.detail != null) {
            root.put("detail", this.detail);
        }
        root.putAll(this.topLevel);
        if (this.production) {
            this.logProduction(internalMap);
        } else {
            internalMap = this.createInternal(type);
        }
        root.putAll(internalMap);
        return root;
    }

    private String normalizeForType(String s) {
        return s.replace(" ", "-").toLowerCase();
    }

    private Map<String, Object> createInternal(String type) {
        LinkedHashMap<String, Object> internalMap = new LinkedHashMap<String, Object>(this.internalFields);
        if (this.exception != null) {
            if (internalMap.containsKey("message")) {
                log.error("Overriding ProblemDetails extensionsMap 'message' entry. Please notify Membrane developers.", (Throwable)new RuntimeException());
            }
            internalMap.put("message", ExceptionUtil.concatMessageAndCauseMessages(this.exception));
            if (this.stacktrace) {
                internalMap.put("stackTrace", ProblemDetails.getStackTrace(this.exception, new StackTraceElement[0]));
            }
        }
        Object see = type;
        if (!this.component.isEmpty()) {
            see = (String)see + "/" + this.normalizeForType(this.component);
        }
        if (this.flow != null) {
            see = (String)see + "/" + this.flow.name().toLowerCase();
        }
        if (!((String)see).isEmpty()) {
            see = (String)see + "/" + this.seeSuffix;
        }
        internalMap.put("see", see);
        internalMap.put("attention", "Membrane is in development mode. For production set <router production=\"true\"> to reduce details in error messages!");
        return internalMap;
    }

    private void logProduction(Map<String, Object> internalMap) {
        String logKey = UUID.randomUUID().toString();
        log.warn("logKey={}\ntype={}\ntitle={}\n,detail={}\n,extension={},.", new Object[]{logKey, this.type, this.title, this.detail, internalMap});
        if (this.type.equals("internal")) {
            this.title = "Internal error";
        }
        this.detail = "Details can be found in the Membrane log searching for key: %s.".formatted(logKey);
        if (this.stacktrace) {
            log.warn("", this.exception);
        }
    }

    @NotNull
    private static Map getStackTrace(Throwable exception, StackTraceElement[] enclosingTrace) {
        LinkedHashMap<Object, Object> m = new LinkedHashMap<Object, Object>();
        StackTraceElement[] trace = exception.getStackTrace();
        int m2 = trace.length - 1;
        for (int n = enclosingTrace.length - 1; m2 >= 0 && n >= 0 && trace[m2].equals(enclosingTrace[n]); --m2, --n) {
        }
        int framesInCommon = trace.length - 1 - m2;
        for (int i = 0; i <= m2; ++i) {
            m.put("e" + i, trace[i].toString());
        }
        if (framesInCommon != 0) {
            m.put("more_frames_in_common", framesInCommon);
        }
        if (exception.getCause() != null) {
            m.put("cause", ProblemDetails.getStackTrace(exception.getCause(), trace));
        }
        return m;
    }

    private Response createContent(Map<String, Object> root, Exchange exchange) {
        Response.ResponseBuilder builder = Response.statusCode(this.statusCode);
        try {
            if (exchange != null && exchange.getRequest().isXML()) {
                ProblemDetails.createXMLContent(root, builder);
            } else {
                ProblemDetails.createJson(root, builder);
            }
        }
        catch (Exception e) {
            builder.body("Title: %s\nType: %s\n%s".formatted(this.type, this.title, root).getBytes());
            builder.contentType("text/plain");
        }
        return builder.build();
    }

    private static void createXMLContent(Map<String, Object> root, Response.ResponseBuilder builder) throws Exception {
        builder.body(ProblemDetails.convertMapToXml(root));
        builder.contentType("application/xml");
    }

    public static String convertMapToXml(Map<String, Object> map) throws Exception {
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element root = document.createElement("problem-details");
        document.appendChild(root);
        ProblemDetails.mapToXmlElements(map, document, root);
        return ProblemDetails.document2string(document);
    }

    private static String document2string(Document document) throws TransformerException {
        StringWriter writer = new StringWriter();
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer t = tf.newTransformer();
        t.setOutputProperty("indent", "yes");
        t.transform(new DOMSource(document), new StreamResult(writer));
        return writer.toString();
    }

    private static void mapToXmlElements(Map<String, Object> map, Document document, Element parent) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object value = entry.getValue();
            if (value == null) continue;
            Element element = document.createElement(entry.getKey());
            if (value instanceof Map) {
                Map mv = (Map)value;
                ProblemDetails.mapToXmlElements(mv, document, element);
            } else {
                if (value instanceof Object[]) {
                    Object[] oa;
                    for (Object obj : oa = (Object[])value) {
                        Element arrayElement = document.createElement(entry.getKey());
                        arrayElement.setTextContent(obj.toString());
                        parent.appendChild(arrayElement);
                    }
                    continue;
                }
                element.setTextContent(value.toString());
            }
            parent.appendChild(element);
        }
    }

    private static void createJson(Map<String, Object> root, Response.ResponseBuilder builder) throws JsonProcessingException {
        builder.body(ow.writeValueAsBytes(root));
        builder.contentType("application/problem+json");
    }

    public static ProblemDetails parse(Response r) throws JsonProcessingException {
        if (r.getHeader().getContentType() == null) {
            throw new RuntimeException("No Content-Type in message with ProblemDetails!");
        }
        if (!r.getHeader().getContentType().equals("application/problem+json")) {
            throw new RuntimeException("Content-Type ist %s but should be %s.".formatted(r.getHeader().getContentType(), "application/problem+json"));
        }
        ProblemDetails pd = new ProblemDetails();
        pd.statusCode(r.getStatusCode());
        TypeReference<Map<String, Object>> typeRef = new TypeReference<Map<String, Object>>(){};
        Map m = (Map)om.readValue(r.getBodyAsStringDecoded(), (TypeReference)typeRef);
        pd.type = (String)m.get("type");
        pd.title = (String)m.get("title");
        pd.detail = (String)m.get("detail");
        for (Map.Entry e : m.entrySet()) {
            if (pd.isReservedProblemDetailsField((String)e.getKey())) continue;
            pd.internal((String)e.getKey(), e.getValue());
        }
        return pd;
    }

    private boolean isReservedProblemDetailsField(String key) {
        for (String reserved : List.of("type", "title", "detail", "instance")) {
            if (!key.equals(reserved)) continue;
            return true;
        }
        return false;
    }

    public String getTitle() {
        return this.title;
    }

    public String getType() {
        return this.type;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public boolean isProduction() {
        return this.production;
    }

    public String getDetail() {
        return this.detail;
    }

    public String getComponent() {
        return this.component;
    }

    public HashMap<String, Object> getInternal() {
        return this.internalFields;
    }

    public Throwable getException() {
        return this.exception;
    }

    public boolean isStacktrace() {
        return this.stacktrace;
    }
}

