/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.exceptions;

import com.predic8.membrane.core.interceptor.ratelimit.RateLimitErrorHandling;
import com.predic8.membrane.core.proxies.SOAPProxyMultipleServicesException;
import com.predic8.membrane.core.transport.PortOccupiedException;
import com.predic8.membrane.core.util.ConfigurationException;
import com.predic8.membrane.core.util.OSUtil;
import java.beans.PropertyChangeEvent;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.springframework.beans.MethodInvocationException;
import org.springframework.beans.PropertyAccessException;
import org.springframework.beans.PropertyBatchUpdateException;

public class SpringConfigurationErrorHandler {
    public static final String STARS = "**********************************************************************************";

    public static void handleRootCause(Exception e, Logger log) {
        ConfigurationException ce = SpringConfigurationErrorHandler.checkForConfigurationException(e);
        if (ce != null) {
            SpringConfigurationErrorHandler.handleConfigurationException(ce);
            return;
        }
        Throwable throwable = ExceptionUtils.getRootCause((Throwable)e);
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PropertyBatchUpdateException.class, ConfigurationException.class, PortOccupiedException.class, SOAPProxyMultipleServicesException.class}, (Object)throwable, n)) {
            case 0: {
                PropertyBatchUpdateException pbue = (PropertyBatchUpdateException)throwable;
                SpringConfigurationErrorHandler.handlePropertyBatchUpdateException(log, pbue);
                break;
            }
            case 1: {
                ConfigurationException ee = (ConfigurationException)throwable;
                SpringConfigurationErrorHandler.handleConfigurationException(ee);
                break;
            }
            case 2: {
                PortOccupiedException poe = (PortOccupiedException)throwable;
                SpringConfigurationErrorHandler.handlePortOccupiedException(poe);
                break;
            }
            case 3: {
                SOAPProxyMultipleServicesException mse = (SOAPProxyMultipleServicesException)throwable;
                SpringConfigurationErrorHandler.handleSOAPProxyMultipleServicesException(mse);
                break;
            }
            default: {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private static ConfigurationException checkForConfigurationException(Exception e) {
        for (Throwable t : ExceptionUtils.getThrowableList((Throwable)e)) {
            if (!(t instanceof ConfigurationException)) continue;
            ConfigurationException ce = (ConfigurationException)t;
            return ce;
        }
        return null;
    }

    private static void handlePortOccupiedException(PortOccupiedException poe) {
        if (poe.getPort() < 1024) {
            System.err.printf("%s\n\nMembrane is configured to open port %d, but the port cannot be opened.\nPlease check:\n\na) The port %d is lower than 1024. Opening it might require root or superuser rights.\nb) The port is already in use by another program.\n\nTo resolve this issue, you can:\n\n1. Configure Membrane to use a different port. Update the port in the `conf/proxies.xml` file,\n   then restart Membrane.\n2. Find and stop the program that is occupying the port. Then restart Membrane.\n\n%s\n\n3. Run Membrane with superuser permissions or use the `setcap` command.\n\n%n", STARS, poe.getPort(), poe.getPort(), SpringConfigurationErrorHandler.getHowToFindPort());
            return;
        }
        System.err.printf("%s\n\nMembrane is configured to open port %d. But this port is already in\"\nuse by a different program. To start Membrane do one of the following:\n\n1. Find and stop the program that is occupying the port. Then restart Membrane.\n\n%s\n\n2. Configure Membrane to use a different port. Probably in the conf/proxies.xml\nfile. Then restart Membrane.\n%n", STARS, poe.getPort(), SpringConfigurationErrorHandler.getHowToFindPort());
    }

    private static String getHowToFindPort() {
        return switch (OSUtil.getOS()) {
            default -> throw new MatchException(null, null);
            case OSUtil.OS.WINDOWS -> SpringConfigurationErrorHandler.getHowToFindPortWindows();
            case OSUtil.OS.LINUX, OSUtil.OS.MAC -> SpringConfigurationErrorHandler.getHowToFindPortLinux();
            case OSUtil.OS.UNKNOWN -> "";
        };
    }

    private static String getHowToFindPortLinux() {
        return "e.g.:\n> lsof -i :2000\nCOMMAND    PID    USER  TYPE\njava     80910 predic8  IPv6  TCP  (LISTEN)\n> kill -9 80910\n";
    }

    private static String getHowToFindPortWindows() {
        return "using the Command Line (cmd):\n  netstat -aon | find /i \"listening\"\nusing the Powershell (powershell):\n  netstat -aon | Select-String -Pattern listening\n";
    }

    private static void handleConfigurationException(ConfigurationException ce) {
        String reason = "";
        if (ce.getCause() != null) {
            reason = "\nReason: %s\n".formatted(ce.getCause().getMessage());
        }
        System.err.printf("************** Configuration Error ***********************************\n\n%s\n%s\n\nGiving up.\n\nCheck proxies.xml file for errors.\n%n", ce.getMessage(), reason);
    }

    private static void handleSOAPProxyMultipleServicesException(SOAPProxyMultipleServicesException e) {
        Object sample = "";
        for (String service : e.getServices()) {
            sample = (String)sample + "<soapProxy wsdl=\"%s\" serviceName=\"%s\">\n...\n</soapProxy>\n\n".formatted(e.getSoapProxy().getWsdl(), service);
        }
        System.err.printf("%s\n\nsoapProxy Configuration Error\n=============================\n\nThe WSDL:\n\n%s\n\ncontains definitions for the following services:\n\n%s\n\nA <soapProxy> can only be configured with one single service. But you can deploy the same\nWSDL several times with different services.\n\n%s\n\nEach <soapProxy> will expose a different service.\n\n\n%n", STARS, e.getSoapProxy().getWsdl(), e.getServices(), sample);
    }

    private static void handlePropertyBatchUpdateException(Logger log, PropertyBatchUpdateException pbue) {
        block6: for (PropertyAccessException ie : pbue.getPropertyAccessExceptions()) {
            if (!(ie instanceof MethodInvocationException)) continue;
            MethodInvocationException mie = (MethodInvocationException)ie;
            PropertyChangeEvent pce = mie.getPropertyChangeEvent();
            switch (Objects.requireNonNull(pce).getPropertyName()) {
                case "requestLimitDuration": {
                    RateLimitErrorHandling.handleRequestLimitDurationConfigurationException(log, pce);
                    continue block6;
                }
                default: {
                    log.error("Invalid value {} for property {}", pce.getNewValue(), (Object)pce.getPropertyName());
                }
            }
        }
    }
}

