/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.exchange;

import com.predic8.membrane.core.exchange.ExchangeState;
import com.predic8.membrane.core.http.BodyCollectingMessageObserver;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.model.IExchangeViewerListener;
import com.predic8.membrane.core.model.IExchangesStoreListener;
import com.predic8.membrane.core.proxies.AbstractServiceProxy;
import com.predic8.membrane.core.proxies.Proxy;
import com.predic8.membrane.core.proxies.ProxyRule;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExchange {
    private static final Logger log = LoggerFactory.getLogger((String)AbstractExchange.class.getName());
    protected Request request;
    private Response response;
    private String originalRequestUri;
    private Calendar time = Calendar.getInstance();
    private String errMessage = "";
    private final Set<IExchangeViewerListener> exchangeViewerListeners = new HashSet<IExchangeViewerListener>();
    private final Set<IExchangesStoreListener> exchangesStoreListeners = new HashSet<IExchangesStoreListener>();
    protected Proxy proxy;
    protected Map<String, Object> properties = new HashMap<String, Object>();
    private ExchangeState status = ExchangeState.STARTED;
    private boolean forceToStop = false;
    private long tReqSent;
    private long tReqReceived;
    private long tResSent;
    private long tResReceived;
    private List<String> destinations = new ArrayList<String>();
    private String remoteAddr;
    private String remoteAddrIp;
    private ArrayList<Interceptor> interceptorStack = new ArrayList(10);
    private int estimatedHeapSize = -1;

    public AbstractExchange() {
    }

    public AbstractExchange(AbstractExchange original) {
        this.properties = new HashMap<String, Object>(original.properties);
        this.originalRequestUri = original.originalRequestUri;
        this.destinations.addAll(original.getDestinations());
        this.proxy = original.getProxy();
    }

    public void setStatus(ExchangeState state) {
        this.status = state;
    }

    public ExchangeState getStatus() {
        return this.status;
    }

    public Calendar getTime() {
        return this.time;
    }

    public void setTime(Calendar time) {
        this.time = time;
    }

    public Request getRequest() {
        return this.request;
    }

    public void setRequest(Request request) {
        this.request = request;
        if (this.request != null) {
            this.request.setErrorMessage(this.errMessage);
        }
        for (IExchangeViewerListener listener : this.exchangeViewerListeners) {
            listener.addRequest(request);
        }
    }

    public Response getResponse() {
        return this.response;
    }

    public void setResponse(Response res) {
        this.response = res;
        if (this.response != null) {
            this.response.setErrorMessage(this.errMessage);
        }
        for (IExchangeViewerListener listener : this.exchangeViewerListeners) {
            listener.addResponse(res);
        }
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public void addExchangeViewerListener(IExchangeViewerListener viewer) {
        this.exchangeViewerListeners.add(viewer);
    }

    public void removeExchangeViewerListener(IExchangeViewerListener viewer) {
        this.exchangeViewerListeners.remove(viewer);
    }

    public void addExchangeStoreListener(IExchangesStoreListener viewer) {
        this.exchangesStoreListeners.add(viewer);
    }

    public void removeExchangeStoreListener(IExchangesStoreListener viewer) {
        this.exchangesStoreListeners.remove(viewer);
    }

    public void setCompleted() {
        this.status = ExchangeState.COMPLETED;
        this.notifyExchangeFinished();
    }

    public void setStopped() {
        this.status = ExchangeState.SENT;
        this.notifyExchangeStopped();
    }

    private void notifyExchangeFinished() {
        for (IExchangeViewerListener iExchangeViewerListener : this.exchangeViewerListeners) {
            iExchangeViewerListener.setExchangeFinished();
        }
        for (IExchangesStoreListener iExchangesStoreListener : this.exchangesStoreListeners) {
            iExchangesStoreListener.setExchangeFinished(this);
        }
    }

    private void notifyExchangeStopped() {
        for (IExchangeViewerListener iExchangeViewerListener : this.exchangeViewerListeners) {
            iExchangeViewerListener.setExchangeStopped();
        }
        for (IExchangesStoreListener iExchangesStoreListener : this.exchangesStoreListeners) {
            iExchangesStoreListener.setExchangeStopped(this);
        }
    }

    public void finishExchange(boolean refresh, String errmsg) {
        this.errMessage = errmsg;
        if (this.status != ExchangeState.COMPLETED) {
            this.status = ExchangeState.FAILED;
            this.forceToStop = true;
        }
        if (this.request != null) {
            this.request.release();
        }
        if (this.response != null) {
            this.response.release();
        }
        if (refresh) {
            this.notifyExchangeFinished();
        }
    }

    public void setForceToStop(boolean forceToStop) {
        this.forceToStop = forceToStop;
    }

    public boolean isForcedToStop() {
        return this.forceToStop;
    }

    public String getErrorMessage() {
        return this.errMessage;
    }

    public void setErrorMessage(String errMessage) {
        this.errMessage = errMessage;
    }

    public void informExchangeViewerOnRemoval() {
        for (IExchangeViewerListener listener : this.exchangeViewerListeners) {
            listener.removeExchange();
        }
    }

    public void setReceived() {
        this.status = ExchangeState.RECEIVED;
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public <T> T getProperty(String key, Class<T> clazz) {
        Object value = this.properties.get(key);
        if (clazz.isInstance(value)) {
            return clazz.cast(value);
        }
        throw new ClassCastException(String.format("Property with key '%s' is not of type %s", key, clazz.getName()));
    }

    public String getStringProperty(String key) {
        return (String)this.properties.get(key);
    }

    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public long getTimeReqSent() {
        return this.tReqSent;
    }

    public void setTimeReqSent(long tReqSent) {
        this.tReqSent = tReqSent;
    }

    public long getTimeReqReceived() {
        return this.tReqReceived;
    }

    public void setTimeReqReceived(long tReqReceived) {
        this.tReqReceived = tReqReceived;
    }

    public void received() {
        this.setTimeReqReceived(System.currentTimeMillis());
    }

    public long getTimeResSent() {
        return this.tResSent;
    }

    public void setTimeResSent(long tResSent) {
        this.tResSent = tResSent;
    }

    public long getTimeResReceived() {
        return this.tResReceived;
    }

    public void setTimeResReceived(long tResReceived) {
        this.tResReceived = tResReceived;
    }

    public String getOriginalRequestUri() {
        return this.originalRequestUri;
    }

    public void setOriginalRequestUri(String requestUri) {
        this.originalRequestUri = requestUri;
    }

    public String getServer() {
        if (this.getProxy() instanceof ProxyRule) {
            try {
                if (this.getRequest().isCONNECTRequest()) {
                    return this.getRequest().getHeader().getHost();
                }
                return new URI(this.getOriginalRequestUri()).getHost();
            }
            catch (URISyntaxException e) {
                log.error("", (Throwable)e);
                return this.getOriginalRequestUri();
            }
        }
        if (this.getProxy() instanceof AbstractServiceProxy) {
            return ((AbstractServiceProxy)this.getProxy()).getTargetHost();
        }
        return "";
    }

    public long getResponseContentLength() {
        long length = this.getResponse().getHeader().getContentLength();
        if (length != -1L) {
            return length;
        }
        if (this.getResponse().getBody().isRead()) {
            try {
                return this.getResponse().getBody().getLength();
            }
            catch (IOException e) {
                log.error("", (Throwable)e);
            }
        }
        return -1L;
    }

    public long getRequestContentLength() {
        return this.getRequest().getHeader().getContentLength();
    }

    public String getRequestContentType() {
        return this.extractContentTypeValue(this.getRequest().getHeader().getContentType());
    }

    public String getResponseContentType() {
        if (this.getResponse() == null) {
            return "";
        }
        return this.extractContentTypeValue(this.getResponse().getHeader().getContentType());
    }

    private String extractContentTypeValue(String contentType) {
        if (contentType == null) {
            return "";
        }
        int index = contentType.indexOf(";");
        if (index > 0) {
            return contentType.substring(0, index);
        }
        return contentType;
    }

    public void setDestinations(List<String> destinations) {
        this.destinations = destinations;
    }

    public List<String> getDestinations() {
        return this.destinations;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public void setRemoteAddr(String remoteAddr) {
        this.remoteAddr = remoteAddr;
    }

    public String getRemoteAddrIp() {
        return this.remoteAddrIp;
    }

    public void setRemoteAddrIp(String remoteAddrIp) {
        this.remoteAddrIp = remoteAddrIp;
    }

    public String toString() {
        return "[time:" + DateFormat.getDateInstance().format(this.time.getTime()) + (String)(this.request != null ? ",requestURI:" + this.request.getUri() : "") + "]";
    }

    public int getHeapSizeEstimation() {
        if (this.estimatedHeapSize == -1) {
            this.estimatedHeapSize = this.estimateHeapSize();
        }
        return this.estimatedHeapSize;
    }

    public int resetHeapSizeEstimation() {
        int estimatedHeapSize2 = this.estimatedHeapSize;
        this.estimatedHeapSize = -1;
        return estimatedHeapSize2;
    }

    protected int estimateHeapSize() {
        return 2600 + (this.originalRequestUri != null ? this.originalRequestUri.length() : 0) + (this.request != null ? this.request.estimateHeapSize() : 0) + (this.response != null ? this.response.estimateHeapSize() : 0);
    }

    public static <T extends AbstractExchange> T updateCopy(T source, T copy, Runnable bodyUpdatedCallback, BodyCollectingMessageObserver.Strategy strategy, long limit) {
        if (bodyUpdatedCallback != null) {
            if (source.getRequest() != null) {
                copy.setRequest((Request)source.getRequest().createSnapshot(bodyUpdatedCallback, strategy, limit));
            }
            if (source.getResponse() != null) {
                copy.setResponse((Response)source.getResponse().createSnapshot(bodyUpdatedCallback, strategy, limit));
            }
        }
        copy.setOriginalRequestUri(source.getOriginalRequestUri());
        copy.setTime(source.getTime());
        copy.setErrorMessage(source.getErrorMessage());
        copy.setProxy(source.getProxy());
        copy.setProperties(new HashMap<String, Object>(source.getProperties()));
        copy.setStatus(source.getStatus());
        copy.setForceToStop(source.isForcedToStop());
        copy.setTimeReqSent(source.getTimeReqSent());
        copy.setTimeReqReceived(source.getTimeReqReceived());
        copy.setTimeResSent(source.getTimeResSent());
        copy.setTimeResReceived(source.getTimeResReceived());
        copy.setDestinations(new ArrayList<String>(source.getDestinations()));
        copy.setRemoteAddr(source.getRemoteAddr());
        copy.setRemoteAddrIp(source.getRemoteAddrIp());
        copy.setInterceptorStack(new ArrayList<Interceptor>(source.getInterceptorStack()));
        return copy;
    }

    public void detach() {
        this.properties.clear();
    }

    public abstract long getId();

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public abstract <T extends AbstractExchange> T createSnapshot(Runnable var1, BodyCollectingMessageObserver.Strategy var2, long var3);

    public ArrayList<Interceptor> getInterceptorStack() {
        return this.interceptorStack;
    }

    public void setInterceptorStack(ArrayList<Interceptor> interceptorStack) {
        this.interceptorStack = interceptorStack;
    }

    public Message getMessage(Interceptor.Flow flow) {
        if (flow.isRequest()) {
            return this.request;
        }
        return this.response;
    }
}

