/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.exchange;

import com.predic8.membrane.core.TerminateException;
import com.predic8.membrane.core.exchange.AbstractExchange;
import com.predic8.membrane.core.http.BodyCollectingMessageObserver;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.proxies.Proxy;
import com.predic8.membrane.core.proxies.SSLableProxy;
import com.predic8.membrane.core.transport.http.AbstractHttpHandler;
import com.predic8.membrane.core.transport.http.Connection;
import com.predic8.membrane.core.util.HttpUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Exchange
extends AbstractExchange {
    public static final String HTTP_SERVLET_REQUEST = "membrane.servlet.request";
    public static final String ALLOW_WEBSOCKET = "membrane.use.websocket";
    public static final String ALLOW_TCP = "membrane.use.tcp";
    public static final String TRACK_NODE_STATUS = "membrane.track.node.status";
    public static final String SSL_CONTEXT = "membrane.ssl.context";
    public static final String OAUTH2 = "membrane.oauth2";
    public static final String SNI_SERVER_NAME = "membrane.sni.server.name";
    public static final String WS_ORIGINAL_EXCHANGE = "membrane.ws.original.exchange";
    public static final String SECURITY_SCHEMES = "membrane.security.schemes";
    private static final Logger log = LoggerFactory.getLogger((String)Exchange.class.getName());
    private AbstractHttpHandler handler;
    private String originalHostHeader = "";
    private Connection targetConnection;
    private int[] nodeStatusCodes;
    private Exception[] nodeExceptions;
    private long id;

    public Exchange(AbstractHttpHandler handler) {
        this.handler = handler;
        this.id = this.hashCode();
    }

    public Exchange(Exchange original, AbstractHttpHandler handler) {
        super(original);
        this.handler = handler;
        this.originalHostHeader = original.originalHostHeader;
        this.id = this.hashCode();
    }

    public AbstractHttpHandler getHandler() {
        return this.handler;
    }

    public String getOriginalHostHeaderHost() {
        return this.originalHostHeader.replaceFirst(":.*", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blockRequestIfNeeded() throws TerminateException {
        if (this.getProxy().isBlockRequest()) {
            Request request = this.getRequest();
            synchronized (request) {
                this.setStopped();
                this.block(this.getRequest());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blockResponseIfNeeded() throws TerminateException {
        if (this.getProxy().isBlockResponse()) {
            Response response = this.getResponse();
            synchronized (response) {
                this.setStopped();
                this.block(this.getResponse());
            }
        }
    }

    public void block(Message msg) throws TerminateException {
        try {
            log.debug("Message thread waits");
            msg.wait();
            log.debug("Message thread received notify");
            if (this.isForcedToStop()) {
                throw new TerminateException("Force the exchange to stop.");
            }
        }
        catch (InterruptedException e1) {
            Thread.currentThread().interrupt();
        }
    }

    public String getOriginalHostHeaderPort() {
        int pos = this.originalHostHeader.indexOf(58);
        if (pos == -1) {
            return "";
        }
        return this.originalHostHeader.substring(pos + 1);
    }

    public String getOriginalHostHeader() {
        return this.originalHostHeader;
    }

    public void setOriginalHostHeader(String hostHeader) {
        this.originalHostHeader = hostHeader;
    }

    @Override
    public void setRequest(Request req) {
        super.setRequest(req);
        if (req != null) {
            this.setOriginalHostHeader(req.getHeader().getHost());
        }
    }

    public Connection getTargetConnection() {
        return this.targetConnection;
    }

    public void setTargetConnection(Connection con) {
        this.targetConnection = con;
    }

    public void collectStatistics() {
        this.proxy.getStatisticCollector().collect(this);
    }

    public String getRequestURI() {
        if (HttpUtil.isAbsoluteURI(this.getOriginalRequestUri())) {
            try {
                return new URL(this.getOriginalRequestUri()).getFile();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Request has a malformed URI: " + this.getOriginalRequestUri(), e);
            }
        }
        return this.getOriginalRequestUri();
    }

    public Map<String, String> getStringProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry e : this.properties.entrySet()) {
            if (!(e.getValue() instanceof String)) continue;
            map.put((String)e.getKey(), (String)e.getValue());
        }
        return map;
    }

    public void setNodeStatusCode(int tryCounter, int code) {
        if (this.nodeStatusCodes == null) {
            this.nodeStatusCodes = new int[this.getDestinations().size()];
        }
        this.nodeStatusCodes[tryCounter % this.getDestinations().size()] = code;
    }

    public void setNodeException(int tryCounter, Exception e) {
        if (this.nodeExceptions == null) {
            this.nodeExceptions = new Exception[this.getDestinations().size()];
        }
        this.nodeExceptions[tryCounter % this.getDestinations().size()] = e;
    }

    @Override
    public void detach() {
        super.detach();
        this.handler = null;
    }

    public boolean canKeepConnectionAlive() {
        return this.getRequest().isKeepAlive() && this.getResponse().isKeepAlive();
    }

    @Override
    public long getId() {
        return this.id;
    }

    public Exchange createSnapshot(Runnable bodyUpdatedCallback, BodyCollectingMessageObserver.Strategy strategy, long limit) {
        Exchange exc = Exchange.updateCopy(this, new Exchange(null), bodyUpdatedCallback, strategy, limit);
        exc.setId(this.getId());
        return exc;
    }

    public void setId(long id) {
        this.id = id;
    }

    public int[] getNodeStatusCodes() {
        return this.nodeStatusCodes;
    }

    public Exception[] getNodeExceptions() {
        return this.nodeExceptions;
    }

    public String getInboundProtocol() {
        Proxy rule = this.getProxy();
        if (!(rule instanceof SSLableProxy)) {
            return "http";
        }
        SSLableProxy sp = (SSLableProxy)rule;
        if (sp.getSslInboundContext() == null) {
            return "http";
        }
        return "https";
    }
}

