/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.exchange;

import com.predic8.membrane.core.exchange.AbstractExchange;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;

public class ExchangesUtil {
    public static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");

    public static String getStatusCode(AbstractExchange exc) {
        if (exc.getResponse() == null) {
            return "";
        }
        return "" + exc.getResponse().getStatusCode();
    }

    public static String getTime(AbstractExchange exc) {
        if (exc.getTime() == null) {
            return "unknown";
        }
        return DATE_FORMATTER.withZone(ZoneId.systemDefault()).format(exc.getTime().getTime().toInstant());
    }

    public static String getRequestContentLength(AbstractExchange exc) {
        if (exc.getRequestContentLength() == -1L) {
            return "unknown";
        }
        return "" + exc.getRequestContentLength();
    }

    public static String getResponseContentLength(AbstractExchange exc) {
        if (exc.getResponseContentLength() == -1L) {
            return "unknown";
        }
        return "" + exc.getResponseContentLength();
    }

    public static String getResponseContentType(AbstractExchange exc) {
        if (exc.getResponse() == null) {
            return "N/A";
        }
        return exc.getResponseContentType();
    }

    public static String getTimeDifference(AbstractExchange exc) {
        return "" + (exc.getTimeResReceived() - exc.getTimeReqSent());
    }
}

