/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.exchangestore;

import com.predic8.membrane.core.exchange.AbstractExchange;
import com.predic8.membrane.core.exchangestore.ClientStatistics;
import com.predic8.membrane.core.exchangestore.ExchangeCollector;
import com.predic8.membrane.core.exchangestore.ExchangeQueryResult;
import com.predic8.membrane.core.exchangestore.ExchangeStore;
import com.predic8.membrane.core.http.HeaderField;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.interceptor.administration.AdminRESTInterceptor;
import com.predic8.membrane.core.interceptor.rest.QueryParameter;
import com.predic8.membrane.core.model.IExchangesStoreListener;
import com.predic8.membrane.core.proxies.Proxy;
import com.predic8.membrane.core.util.ComparatorFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExchangeStore
implements ExchangeStore {
    private static final Logger log = LoggerFactory.getLogger(AbstractExchangeStore.class);
    protected final Set<IExchangesStoreListener> exchangesStoreListeners = new HashSet<IExchangesStoreListener>();

    @Override
    public void addExchangesStoreListener(IExchangesStoreListener viewer) {
        this.exchangesStoreListeners.add(viewer);
    }

    @Override
    public void removeExchangesStoreListener(IExchangesStoreListener viewer) {
        this.exchangesStoreListeners.remove(viewer);
    }

    @Override
    public void refreshExchangeStoreListeners() {
        for (IExchangesStoreListener listener : this.exchangesStoreListeners) {
            listener.refresh();
        }
    }

    public void notifyListenersOnExchangeAdd(Proxy proxy, AbstractExchange exchange) {
        for (IExchangesStoreListener listener : this.exchangesStoreListeners) {
            exchange.addExchangeStoreListener(listener);
            listener.addExchange(proxy, exchange);
        }
    }

    public void notifyListenersOnExchangeRemoval(AbstractExchange exchange) {
        for (IExchangesStoreListener listener : this.exchangesStoreListeners) {
            exchange.removeExchangeStoreListener(listener);
            listener.removeExchange(exchange);
        }
    }

    @Override
    public AbstractExchange getExchangeById(long id) {
        throw new UnsupportedOperationException("getExchangeById must be implemented in the sub class.");
    }

    @Override
    public List<? extends ClientStatistics> getClientStatistics() {
        throw new UnsupportedOperationException("getClientStatistics must be implemented in the sub class.");
    }

    @Override
    public synchronized void collect(ExchangeCollector collector) {
        for (AbstractExchange exc : this.getAllExchangesAsList()) {
            try {
                collector.collect(exc);
            }
            catch (Exception e) {
                log.debug("Error while collecting properties from Exchange.", (Throwable)e);
            }
        }
    }

    @Override
    public long getLastModified() {
        return System.currentTimeMillis();
    }

    @Override
    public void waitForModification(long lastKnownModification) throws InterruptedException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExchangeQueryResult getFilteredSortedPaged(QueryParameter params, boolean useXForwardedForAsClientAddr) throws Exception {
        List<AbstractExchange> exchanges;
        long lm;
        List<AbstractExchange> list = this.getAllExchangesAsList();
        synchronized (list) {
            lm = this.getLastModified();
            exchanges = new ArrayList<AbstractExchange>(this.getAllExchangesAsList());
        }
        exchanges = this.filter(params, useXForwardedForAsClientAddr, exchanges);
        exchanges.sort(ComparatorFactory.getAbstractExchangeComparator(params.getString("sort", "time"), params.getString("order", "desc")));
        return new ExchangeQueryResult(AbstractExchangeStore.getPaginated(params, exchanges, params.getInt("offset", 0)), exchanges.size(), lm);
    }

    private static List<AbstractExchange> getPaginated(QueryParameter params, List<AbstractExchange> exchanges, int offset) {
        return exchanges.subList(offset, Math.min(offset + AbstractExchangeStore.getMax(params, exchanges), exchanges.size()));
    }

    protected static int getMax(QueryParameter params, List<AbstractExchange> exchanges) {
        return params.getInt("max", exchanges.size());
    }

    private List<AbstractExchange> filter(QueryParameter params, boolean useXForwardedForAsClientAddr, List<AbstractExchange> exchanges) {
        boolean noClient = !params.has("client");
        boolean noServer = !params.has("server");
        boolean noMethod = !params.has("method");
        boolean noReqcontenttypn = !params.has("reqcontenttype");
        boolean noRespcontenttype = !params.has("respcontenttype");
        boolean noSearch = !params.has("search");
        boolean noStatuscode = !params.has("statuscode");
        String client = params.getString("client");
        String server = params.getString("server");
        String method = params.getString("method");
        String reqcontenttype = params.getString("reqcontenttype");
        String respcontenttype = params.getString("respcontenttype");
        String search = params.getString("search");
        int statuscode = noStatuscode ? -1 : params.getInt("statuscode");
        return exchanges.stream().filter(e -> AbstractExchangeStore.filterExchanges(params, useXForwardedForAsClientAddr, noStatuscode, noClient, noServer, noMethod, noReqcontenttypn, noRespcontenttype, noSearch, statuscode, client, server, method, reqcontenttype, respcontenttype, search, e)).collect(Collectors.toList());
    }

    private static boolean filterExchanges(QueryParameter params, boolean useXForwardedForAsClientAddr, boolean noStatuscode, boolean noClient, boolean noServer, boolean noMethod, boolean noReqcontenttypn, boolean noRespcontenttype, boolean noSearch, int statuscode, String client, String server, String method, String reqcontenttype, String respcontenttype, String search, AbstractExchange e) {
        return !(params.has("proxy") && !e.getProxy().toString().equals(params.getString("proxy")) || !noStatuscode && !AbstractExchangeStore.compareStatusCode(statuscode, e) || !noClient && !AdminRESTInterceptor.getClientAddr(useXForwardedForAsClientAddr, e).equals(client) || !noServer && !server.equals(e.getServer() == null ? "" : e.getServer()) || !noMethod && !e.getRequest().getMethod().equals(method) || !noReqcontenttypn && !e.getRequestContentType().equals(reqcontenttype) || !noRespcontenttype && !e.getResponseContentType().equals(respcontenttype) || !noSearch && !AbstractExchangeStore.bodyContains(search, e) && !AbstractExchangeStore.requestHeaderContains(search, e) && !AbstractExchangeStore.responseHeaderContains(search, e));
    }

    private static boolean compareStatusCode(int statuscode, AbstractExchange e) {
        if (e.getResponse() == null) {
            return false;
        }
        return e.getResponse().getStatusCode() == statuscode;
    }

    protected static boolean pathContains(String search, AbstractExchange e) {
        return StringUtils.containsIgnoreCase((CharSequence)e.getRequest().getUri(), (CharSequence)search);
    }

    protected static boolean requestHeaderContains(String search, AbstractExchange e) {
        return AbstractExchangeStore.headerFieldsContains(search, e.getRequest().getHeader().getAllHeaderFields());
    }

    protected static boolean responseHeaderContains(String search, AbstractExchange e) {
        if (e.getResponse() == null) {
            return false;
        }
        return AbstractExchangeStore.headerFieldsContains(search, e.getResponse().getHeader().getAllHeaderFields());
    }

    private static boolean headerFieldsContains(String search, HeaderField[] fields) {
        for (HeaderField field : fields) {
            if (StringUtils.containsIgnoreCase((CharSequence)field.getHeaderName().toString(), (CharSequence)search)) {
                return true;
            }
            if (!StringUtils.containsIgnoreCase((CharSequence)field.getValue(), (CharSequence)search)) continue;
            return true;
        }
        return false;
    }

    private static boolean bodyContains(String search, AbstractExchange e) {
        return AbstractExchangeStore.bodyContains(search, e.getRequest()) || e.getResponse() != null && AbstractExchangeStore.bodyContains(search, e.getResponse());
    }

    private static boolean bodyContains(String search, Message msg) {
        try {
            if (msg.isBodyEmpty()) {
                return false;
            }
            return StringUtils.containsIgnoreCase((CharSequence)msg.getBodyAsStringDecoded(), (CharSequence)search);
        }
        catch (Exception e) {
            return false;
        }
    }
}

