/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.exchangestore;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.exchange.AbstractExchange;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.exchange.snapshots.AbstractExchangeSnapshot;
import com.predic8.membrane.core.exchange.snapshots.DynamicAbstractExchangeSnapshot;
import com.predic8.membrane.core.exchangestore.AbstractExchangeStore;
import com.predic8.membrane.core.exchangestore.ExchangeCollector;
import com.predic8.membrane.core.exchangestore.ExchangeQueryResult;
import com.predic8.membrane.core.http.BodyCollectingMessageObserver;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.administration.PropertyValueCollector;
import com.predic8.membrane.core.interceptor.rest.QueryParameter;
import com.predic8.membrane.core.proxies.Proxy;
import com.predic8.membrane.core.proxies.RuleKey;
import com.predic8.membrane.core.proxies.StatisticCollector;
import com.predic8.membrane.core.transport.http.HttpClient;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.io.IOUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="elasticSearchExchangeStore")
public class ElasticSearchExchangeStore
extends AbstractExchangeStore {
    HttpClient client;
    static Logger log = LoggerFactory.getLogger(ElasticSearchExchangeStore.class);
    int updateIntervalMs = 1000;
    private final Map<Long, AbstractExchangeSnapshot> shortTermMemoryForBatching = new HashMap<Long, AbstractExchangeSnapshot>();
    Cache<Long, AbstractExchangeSnapshot> cacheToWaitForElasticSearchIndex = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.SECONDS).build();
    Thread updateJob;
    String index = "membrane";
    ObjectMapper mapper;
    String location = "http://localhost:9200";
    private String documentPrefix;
    private long startTime;
    boolean init = false;
    private int maxBodySize = 100000;
    private BodyCollectingMessageObserver.Strategy bodyExceedingMaxSizeStrategy = BodyCollectingMessageObserver.Strategy.TRUNCATE;
    ImmutableMap<String, String> queryToElasticMap = ImmutableMap.builder().putAll(Stream.of({"method", "request.method.keyword"}, {"server", "server.keyword"}, {"client", "remoteAddr.keyword"}, {"respcontenttype", "response.header.Content-Type.keyword"}, {"reqcontenttype", "request.header.Content-Type.keyword"}, {"reqcontentlength", "request.header.Content-Length.keyword"}, {"respcontentlength", "response.header.Content-Length.keyword"}, {"statuscode", "response.statusCode"}, {"path", "request.uri.keyword"}, {"proxy", "rule.name.keyword"}).collect(Collectors.toMap(data -> data[0], data -> data[1]))).build();

    @Override
    public void init(Router router) {
        super.init(router);
        if (this.client == null) {
            this.client = router.getHttpClientFactory().createClient(null);
        }
        if (this.mapper == null) {
            this.mapper = new ObjectMapper();
        }
        if (this.documentPrefix == null) {
            this.documentPrefix = ElasticSearchExchangeStore.getLocalHostname();
        }
        this.documentPrefix = this.documentPrefix.toLowerCase();
        this.startTime = System.nanoTime();
        this.setUpIndex();
        this.updateJob = new Thread(() -> {
            try {
                while (true) {
                    ArrayList<AbstractExchangeSnapshot> exchanges;
                    Map<Long, AbstractExchangeSnapshot> map = this.shortTermMemoryForBatching;
                    synchronized (map) {
                        exchanges = new ArrayList<AbstractExchangeSnapshot>(this.shortTermMemoryForBatching.values());
                        this.shortTermMemoryForBatching.values().forEach(exc -> this.cacheToWaitForElasticSearchIndex.put((Object)exc.getId(), exc));
                        this.shortTermMemoryForBatching.clear();
                    }
                    if (!exchanges.isEmpty()) {
                        this.sendToElasticSearch(exchanges);
                        continue;
                    }
                    Thread.sleep(this.updateIntervalMs);
                }
            }
            catch (InterruptedException e) {
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        this.updateJob.start();
        this.init = true;
    }

    private void sendToElasticSearch(List<AbstractExchangeSnapshot> exchanges) throws Exception {
        String data = exchanges.stream().map(exchange -> this.wrapForBulkOperationElasticSearch(this.index, this.getLocalMachineNameWithSuffix() + "-" + exchange.getId(), this.collectExchangeDataFrom((AbstractExchangeSnapshot)exchange))).collect(Collectors.joining());
        Exchange elasticSearchExc = new Request.Builder().post(this.location + "/_bulk").header("Content-Type", "application/x-ndjson").body(data).buildExchange();
        this.client.call(elasticSearchExc);
    }

    private static String getLocalHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            try {
                return IOUtils.toString((InputStream)Runtime.getRuntime().exec("hostname").getInputStream());
            }
            catch (IOException e1) {
                log.error("Unable to get hostname of localhost.", (Throwable)e1);
                return "localhost";
            }
        }
    }

    private String getLocalMachineNameWithSuffix() {
        return this.documentPrefix + "-" + this.startTime;
    }

    public String wrapForBulkOperationElasticSearch(String index, String id, String value) {
        return "{ \"index\" : { \"_index\" : \"" + index + "\", \"_id\" : \"" + id + "\" } }\n" + value + "\n";
    }

    @Override
    public void snap(AbstractExchange exc, Interceptor.Flow flow) {
        try {
            if (flow == Interceptor.Flow.REQUEST) {
                DynamicAbstractExchangeSnapshot excCopy = new DynamicAbstractExchangeSnapshot(exc, flow, this::addForElasticSearch, this.bodyExceedingMaxSizeStrategy, this.maxBodySize);
                this.addForElasticSearch(excCopy);
            } else {
                AbstractExchangeSnapshot excCopy = this.getExchangeDtoById((int)exc.getId());
                DynamicAbstractExchangeSnapshot.addObservers(exc, excCopy, this::addForElasticSearch, flow);
                excCopy = excCopy.updateFrom(exc, flow);
                this.addForElasticSearch(excCopy);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addForElasticSearch(AbstractExchangeSnapshot exc) {
        Map<Long, AbstractExchangeSnapshot> map = this.shortTermMemoryForBatching;
        synchronized (map) {
            this.shortTermMemoryForBatching.put(exc.getId(), exc);
        }
    }

    private String collectExchangeDataFrom(AbstractExchangeSnapshot exc) {
        try {
            Map value = (Map)this.mapper.readValue(this.mapper.writeValueAsString((Object)exc), Map.class);
            value.put("issuer", this.documentPrefix);
            return this.mapper.writeValueAsString((Object)value);
        }
        catch (IOException e) {
            log.error("While collecting data from %s", (Object)exc.getRequest().getUri(), (Object)e);
            return "";
        }
    }

    @Override
    public synchronized void collect(ExchangeCollector collector) {
        try {
            ((PropertyValueCollector)collector).getProxies().addAll(this.getPropertyValueArray("rule.name.keyword"));
            ((PropertyValueCollector)collector).getMethods().addAll(this.getPropertyValueArray("request.method.keyword"));
            ((PropertyValueCollector)collector).getClients().addAll(this.getPropertyValueArray("remoteAddr.keyword"));
            ((PropertyValueCollector)collector).getReqContentTypes().addAll(this.getPropertyValueArray("request.header.Content-Type.keyword"));
            ((PropertyValueCollector)collector).getStatusCodes().addAll(this.getPropertyValueArray("response.statusCode").stream().map(Integer::parseInt).collect(Collectors.toSet()));
            ((PropertyValueCollector)collector).getRespContentTypes().addAll(this.getPropertyValueArray("response.header.Content-Type.keyword"));
            ((PropertyValueCollector)collector).getServers().addAll(this.getPropertyValueArray("server.keyword"));
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
    }

    private JSONObject getFilterDistinctQueryJson(String field) {
        JSONObject query = new JSONObject();
        query.put("size", 0);
        JSONObject aggs = new JSONObject();
        JSONObject langs = new JSONObject();
        JSONObject terms = new JSONObject();
        terms.put("field", (Object)field);
        terms.put("size", 500);
        langs.put("terms", (Object)terms);
        aggs.put("langs", (Object)langs);
        query.put("aggs", (Object)aggs);
        return query;
    }

    private List<String> getPropertyValueArray(String propertyName) throws Exception {
        Request.Builder builder = new Request.Builder().post(this.location + "/_search").contentType("application/json");
        Exchange clientExc = builder.body(this.getFilterDistinctQueryJson(propertyName).toString()).buildExchange();
        clientExc = this.client.call(clientExc);
        return this.getDistinctValues(clientExc.getResponse().getBodyAsStringDecoded());
    }

    private List<String> getDistinctValues(String responseJson) {
        return StreamSupport.stream(new JSONObject(responseJson).getJSONObject("aggregations").getJSONObject("langs").getJSONArray("buckets").spliterator(), false).map(q -> ((JSONObject)q).get("key").toString()).collect(Collectors.toList());
    }

    public AbstractExchangeSnapshot getExchangeDtoById(int id) {
        Long idBox = id;
        if (this.shortTermMemoryForBatching.get(idBox) != null) {
            return this.shortTermMemoryForBatching.get(idBox);
        }
        if (this.cacheToWaitForElasticSearchIndex.getIfPresent((Object)idBox) != null) {
            return (AbstractExchangeSnapshot)this.cacheToWaitForElasticSearchIndex.getIfPresent((Object)idBox);
        }
        return this.getFromElasticSearchById(id);
    }

    private AbstractExchangeSnapshot getFromElasticSearchById(long id) {
        try {
            String body = "{\n  \"query\": {\n    \"bool\": {\n      \"must\": [\n        {\n          \"match\": {\n            \"issuer\": \"%s\"\n          }\n        },\n        {\n          \"match\": {\n            \"id\": \"%s\"\n          }\n        }\n      ]\n    }\n  }\n}".formatted(this.documentPrefix, id);
            Exchange exc = new Request.Builder().post(this.getElasticSearchExchangesPath() + "_search").body(body).contentType("application/json").buildExchange();
            exc = this.client.call(exc);
            Map excJson = this.getSourceElementFromElasticSearchResponse(this.responseToMap(exc)).getFirst();
            return (AbstractExchangeSnapshot)this.mapper.readValue(this.mapper.writeValueAsString((Object)excJson), AbstractExchangeSnapshot.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getElasticSearchExchangesPath() {
        return this.location + "/" + this.index + "/";
    }

    private String getElasticSearchIndexPath() {
        return this.location + "/" + this.index + "/";
    }

    public List<Map> getSourceElementFromElasticSearchResponse(Map response) {
        return this.getSourceElementFromHitsElement(this.getHitsElementFromElasticSearchResponse(response));
    }

    public List getHitsElementFromElasticSearchResponse(Map response) {
        return (List)((Map)response.get("hits")).get("hits");
    }

    public List<Map> getSourceElementFromHitsElement(List hits) {
        return hits.stream().map(hit -> ((Map)hit).get("_source")).collect(Collectors.toList());
    }

    @Override
    public AbstractExchange getExchangeById(long id) {
        return this.getFromElasticSearchById(id).toAbstractExchange();
    }

    @Override
    public void remove(AbstractExchange exchange) {
        try {
            this.removeFromElasticSearchById(exchange.getId());
        }
        catch (Exception e) {
            log.error("While removing the Exchange.", (Throwable)e);
        }
    }

    private void removeFromElasticSearchById(long id) throws Exception {
        Exchange exc = new Request.Builder().delete(this.getElasticSearchExchangesPath() + this.getLocalMachineNameWithSuffix() + "-" + id).buildExchange();
        this.client.call(exc);
    }

    @Override
    public void removeAllExchanges(Proxy proxy) {
        String name = proxy.toString();
        try {
            String body = "{\n  \"query\": {\n    \"bool\": {\n      \"must\": [\n        {\n          \"match\": {\n            \"issuer\": \"%s\"\n          }\n        },\n        {\n          \"match\": {\n            \"rule.name\": \"%s\"\n          }\n        }\n      ]\n    }\n  }\n}".formatted(this.documentPrefix, name);
            Exchange exc = new Request.Builder().post(this.getElasticSearchExchangesPath() + "_delete_by_query").body(body).contentType("application/json").buildExchange();
            this.client.call(exc);
        }
        catch (Exception e) {
            log.error("While removing all Exchanges for proxy {}.", (Object)proxy.getName(), (Object)e);
        }
    }

    @Override
    public void removeAllExchanges(AbstractExchange[] exchanges) {
        String exchangeIdsCommaSeparated = Stream.of(exchanges).map(AbstractExchange::getId).map(Objects::toString).collect(Collectors.joining(","));
        try {
            String body = "{\n  \"query\": {\n    \"bool\": {\n      \"must\": [\n        {\n          \"match\": {\n            \"issuer\": \"%s\"\n          }\n        },\n        {\n          \"terms\": {\n            \"id\": \"%s\"\n          }\n        }\n      ]\n    }\n  }\n}".formatted(this.documentPrefix, "[" + exchangeIdsCommaSeparated + "]");
            Exchange exc = new Request.Builder().post(this.getElasticSearchExchangesPath() + "_delete_by_query").body(body).contentType("application/json").buildExchange();
            this.client.call(exc);
        }
        catch (Exception e) {
            log.error("While removing all Exchanges.", (Throwable)e);
        }
    }

    @Override
    public AbstractExchange[] getExchanges(RuleKey ruleKey) {
        int port = ruleKey.getPort();
        try {
            String body = "{\n  \"query\": {\n    \"bool\": {\n      \"must\": [\n        {\n          \"match\": {\n            \"issuer\": \"%s\"\n          }\n        },\n        {\n          \"match\": {\n            \"rule.port\": \"%d\"\n          }\n        }\n      ]\n    }\n  }\n}".formatted(this.documentPrefix, port);
            Exchange exc = new Request.Builder().post(this.getElasticSearchExchangesPath() + "_search").body(body).contentType("application/json").buildExchange();
            exc = this.client.call(exc);
            List<Map> source = this.getSourceElementFromElasticSearchResponse(this.responseToMap(exc));
            AbstractExchangeSnapshot[] snapshots = (AbstractExchangeSnapshot[])this.mapper.readValue(this.mapper.writeValueAsString(source), AbstractExchangeSnapshot[].class);
            return (AbstractExchange[])Stream.of(snapshots).map(AbstractExchangeSnapshot::toAbstractExchange).toArray(AbstractExchange[]::new);
        }
        catch (Exception e) {
            log.error("While retrieving all Exchanges.", (Throwable)e);
            return new AbstractExchange[0];
        }
    }

    @Override
    public StatisticCollector getStatistics(RuleKey ruleKey) {
        StatisticCollector statistics = new StatisticCollector(false);
        List<AbstractExchange> exchangesList = Arrays.asList(this.getExchanges(ruleKey));
        if (exchangesList == null || exchangesList.isEmpty()) {
            return statistics;
        }
        for (AbstractExchange abstractExchange : exchangesList) {
            statistics.collectFrom(abstractExchange);
        }
        return statistics;
    }

    @Override
    public Object[] getAllExchanges() {
        return this.getAllExchangesAsList().toArray();
    }

    @Override
    public List<AbstractExchange> getAllExchangesAsList() {
        try {
            String body = "{\n  \"query\": {\n    \"match\": {\n      \"issuer\": \"%s\"\n    }\n  }\n}".formatted(this.documentPrefix);
            Exchange exc = new Request.Builder().post(this.getElasticSearchExchangesPath() + "_search").contentType("application/json").body(body).buildExchange();
            exc = this.client.call(exc);
            if (!exc.getResponse().isOk()) {
                return new ArrayList<AbstractExchange>();
            }
            return this.getAbstractExchangeListFromExchange(exc);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private List<AbstractExchange> getAbstractExchangeListFromExchange(Exchange exc) throws IOException {
        List<Map> sources = this.getSourceElementFromElasticSearchResponse(this.responseToMap(exc));
        return sources.stream().map(source -> {
            try {
                return ((AbstractExchangeSnapshot)this.mapper.readValue(this.mapper.writeValueAsString(source), AbstractExchangeSnapshot.class)).toAbstractExchange();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
    }

    @Override
    public ExchangeQueryResult getFilteredSortedPaged(QueryParameter params, boolean useXForwardedForAsClientAddr) throws Exception {
        JSONObject req = this.getJsonElasticQuery(params);
        Exchange exc = new Request.Builder().post(this.getElasticSearchExchangesPath() + "_search").contentType("application/json").body(req.toString()).buildExchange();
        exc = this.client.call(exc);
        return new ExchangeQueryResult(this.getAbstractExchangeListFromExchange(exc), this.getTotalHitCountFromExchange(exc), this.getLastModified());
    }

    private JSONObject getJsonElasticQuery(QueryParameter params) {
        JSONObject req = new JSONObject();
        req.put("from", (Object)params.getString("offset"));
        req.put("size", (Object)params.getString("max"));
        JSONObject query = new JSONObject();
        req.put("query", (Object)query);
        JSONObject bool = new JSONObject();
        query.put("bool", (Object)bool);
        JSONArray must = new JSONArray();
        bool.put("must", (Object)must);
        if (!params.getString("sort").equals("duration")) {
            req.put("sort", (Object)this.getSortJSONArray((String)this.queryToElasticMap.getOrDefault((Object)params.getString("sort").toLowerCase(), (Object)params.getString("sort")), params.getString("order")));
        } else {
            req.put("sort", (Object)this.getDurationScriptObject(params.getString("order")));
        }
        List<String> existingFields = this.queryToElasticMap.keySet().stream().filter(params::has).toList();
        existingFields.forEach(eF -> must.put((Object)this.getMatchJSON((String)this.queryToElasticMap.get(eF), params.getString((String)eF))));
        must.put((Object)new JSONObject().put("match", (Object)new JSONObject().put("issuer", (Object)this.documentPrefix)));
        return req;
    }

    private JSONObject getDurationScriptObject(String sortOrder) {
        JSONObject main = new JSONObject();
        JSONObject _script = new JSONObject();
        _script.put("type", (Object)"number");
        JSONObject script = new JSONObject();
        script.put("lang", (Object)"painless");
        script.put("source", (Object)"doc['timeResReceived'].value - doc['timeReqSent'].value");
        _script.put("order", (Object)this.getElasticSortOrder(sortOrder));
        _script.put("script", (Object)script);
        main.put("_script", (Object)_script);
        return main;
    }

    private JSONObject getMatchJSON(String key, String value) {
        return new JSONObject().put("match", (Object)new JSONObject().put(key, (Object)value));
    }

    private JSONArray getSortJSONArray(String key, String sortOrder) {
        sortOrder = this.getElasticSortOrder(sortOrder);
        return new JSONArray().put((Object)new JSONObject().put(key, (Object)sortOrder));
    }

    private String getElasticSortOrder(String sortOrder) {
        sortOrder = sortOrder.equals("asc") ? "asc" : "desc";
        return sortOrder;
    }

    private void setUpIndex() {
        try {
            log.info("Setting up elastic search index");
            Exchange indexExc = new Request.Builder().put(this.getElasticSearchIndexPath()).buildExchange();
            indexExc = this.client.call(indexExc);
            JSONObject indexRes = new JSONObject(indexExc.getResponse().getBodyAsStringDecoded());
            try {
                if (this.isElasticAcked(indexRes)) {
                    log.info("Index {} created", (Object)this.index);
                }
            }
            catch (JSONException e) {
                if (indexRes.getJSONObject("error").getJSONArray("root_cause").getJSONObject(0).getString("type").equals("resource_already_exists_exception")) {
                    log.info("Index already exists skipping index creation");
                }
                log.error("Error happened. Reply from elastic search is below");
                log.error(indexRes.toString());
            }
            log.info("Setting up elastic search mappings");
            String mapping = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("com.predic8.membrane.core.exchangestore/mapping.json"), (Charset)StandardCharsets.UTF_8);
            Exchange currentMappingExc = this.client.call(new Request.Builder().get(this.getElasticSearchIndexPath() + "_mapping").buildExchange());
            String currentMapping = this.client.call(currentMappingExc).getResponse().getBodyAsStringDecoded();
            if (!new JSONObject(currentMapping).getJSONObject(this.index).getJSONObject("mappings").isEmpty()) {
                log.info("Mapping already set skipping");
                return;
            }
            Exchange exc = this.client.call(new Request.Builder().put(this.getElasticSearchIndexPath() + "_mapping").contentType("application/json").body(mapping).buildExchange());
            JSONObject res = new JSONObject(exc.getResponse().getBodyAsStringDecoded());
            try {
                if (this.isElasticAcked(res)) {
                    log.info("Elastic store mapping update completed");
                }
            }
            catch (JSONException e) {
                log.error("There is an error while updating mapping for elastic search. Response from elastic search: {}", (Object)res, (Object)e);
            }
        }
        catch (Exception e) {
            log.error("While setting up ElasticSearch Index.", (Throwable)e);
        }
    }

    private boolean isElasticAcked(JSONObject json) {
        return json.getBoolean("acknowledged");
    }

    private Map responseToMap(Exchange exc) throws IOException {
        return (Map)this.mapper.readValue(exc.getResponse().getBodyAsStringDecoded(), Map.class);
    }

    private int getTotalHitCountFromExchange(Exchange exc) {
        return new JSONObject(exc.getResponse().getBodyAsStringDecoded()).getJSONObject("hits").getJSONObject("total").getInt("value");
    }

    public HttpClient getClient() {
        return this.client;
    }

    @MCAttribute
    public void setClient(HttpClient client) {
        this.client = client;
    }

    public int getUpdateIntervalMs() {
        return this.updateIntervalMs;
    }

    @MCAttribute
    public void setUpdateIntervalMs(int updateIntervalMs) {
        this.updateIntervalMs = updateIntervalMs;
    }

    public String getLocation() {
        return this.location;
    }

    @MCAttribute
    public void setLocation(String location) {
        this.location = location;
    }

    @MCAttribute
    public void setIndex(String index) {
        this.index = index;
    }

    public String getIndex() {
        return this.index;
    }

    public String getDocumentPrefix() {
        return this.documentPrefix;
    }

    @MCAttribute
    public void setDocumentPrefix(String documentPrefix) {
        this.documentPrefix = documentPrefix;
    }

    public int getMaxBodySize() {
        return this.maxBodySize;
    }

    @MCAttribute
    public void setMaxBodySize(int maxBodySize) {
        this.maxBodySize = maxBodySize;
    }

    public BodyCollectingMessageObserver.Strategy getBodyExceedingMaxSizeStrategy() {
        return this.bodyExceedingMaxSizeStrategy;
    }

    @MCAttribute
    public void setBodyExceedingMaxSizeStrategy(BodyCollectingMessageObserver.Strategy bodyExceedingMaxSizeStrategy) {
        this.bodyExceedingMaxSizeStrategy = bodyExceedingMaxSizeStrategy;
    }
}

