/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.graphql;

import com.google.common.collect.Lists;
import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.graphql.GraphQLOverHttpValidationException;
import com.predic8.membrane.core.graphql.GraphQLoverHttpValidator;
import com.predic8.membrane.core.graphql.blocklist.FeatureBlocklist;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.util.TextUtil;
import java.security.InvalidParameterException;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="graphQLProtection")
public class GraphQLProtectionInterceptor
extends AbstractInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(GraphQLProtectionInterceptor.class);
    private boolean allowExtensions = false;
    private List<String> allowedMethods = Lists.newArrayList((Object[])new String[]{"GET", "POST"});
    private int maxRecursion = 3;
    private int maxDepth = 7;
    private int maxMutations = 5;
    private FeatureBlocklist featureBlocklist;
    private GraphQLoverHttpValidator validator;

    public GraphQLProtectionInterceptor() {
        this.name = "graphql protection";
    }

    @Override
    public void init() {
        super.init();
        this.validator = new GraphQLoverHttpValidator(this.allowExtensions, this.allowedMethods, this.maxRecursion, this.maxDepth, this.maxMutations, this.featureBlocklist, this.router);
    }

    @Override
    public Outcome handleRequest(Exchange exc) {
        try {
            this.validator.validate(exc);
        }
        catch (GraphQLOverHttpValidationException e) {
            return this.error(exc, e);
        }
        return Outcome.CONTINUE;
    }

    private Outcome error(Exchange exc, GraphQLOverHttpValidationException e) {
        LOG.warn(e.getMessage());
        exc.setResponse(Response.badRequest().status(e.getStatusCode()).build());
        return Outcome.RETURN;
    }

    @MCAttribute
    public void setMaxMutations(int maxMutations) {
        this.maxMutations = maxMutations;
    }

    public int getMaxMutations() {
        return this.maxMutations;
    }

    @MCAttribute
    public void setAllowExtensions(boolean allowExtensions) {
        this.allowExtensions = allowExtensions;
    }

    public boolean isAllowExtensions() {
        return this.allowExtensions;
    }

    public String getAllowedMethods() {
        return String.join((CharSequence)",", this.allowedMethods);
    }

    @MCAttribute
    public void setAllowedMethods(String allowedMethods) {
        this.allowedMethods = Arrays.asList(allowedMethods.split(","));
        for (String allowedMethod : this.allowedMethods) {
            if ("GET".equals(allowedMethod) || "POST".equals(allowedMethod)) continue;
            throw new InvalidParameterException("<graphQLProtectionInterceptor allowedMethods=\"...\" /> may only allow GET or POST.");
        }
    }

    public int getMaxRecursion() {
        return this.maxRecursion;
    }

    @MCAttribute
    public void setMaxRecursion(int maxRecursion) {
        this.maxRecursion = maxRecursion;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    @MCAttribute
    public void setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
    }

    public FeatureBlocklist getBlacklist() {
        return this.featureBlocklist;
    }

    @MCChildElement
    public void setBlocklist(FeatureBlocklist featureBlocklist) {
        this.featureBlocklist = featureBlocklist;
    }

    @Override
    public String toString() {
        return "GraphQL protection";
    }

    @Override
    public String getShortDescription() {
        return "Let only well-formed GraphQL requests pass. Apply restrictions.";
    }

    @Override
    public String getLongDescription() {
        return "<div>Protects against some GraphQL attack classes (checks HTTP request against <a href=\"https://spec.graphql.org/October2021/\">GraphQL</a> and <a href=\"https://github.com/graphql/graphql-over-http/blob/a1e6d8ca248c9a19eb59a2eedd988c204909ee3f/spec/GraphQLOverHTTP.md\">GraphQL-over-HTTP</a> specs).<br/>GraphQL extensions: " + (this.allowExtensions ? "Allowed." : "Forbidden.") + "<br/>Allowed HTTP verbs: " + TextUtil.toEnglishList("and", this.allowedMethods.toArray(new String[0])) + ".<br/>Maximum allowed nested query levels: " + this.maxDepth + "<br/>Maximum allowed recursion levels (nested repetitions of the same word): " + this.maxRecursion + ".</div>";
    }
}

