/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.graphql;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.graphql.GraphQLOverHttpValidationException;
import com.predic8.membrane.core.graphql.GraphQLParser;
import com.predic8.membrane.core.graphql.GraphQLValidator;
import com.predic8.membrane.core.graphql.blocklist.FeatureBlocklist;
import com.predic8.membrane.core.graphql.model.ExecutableDefinition;
import com.predic8.membrane.core.graphql.model.ExecutableDocument;
import com.predic8.membrane.core.graphql.model.Field;
import com.predic8.membrane.core.graphql.model.FragmentDefinition;
import com.predic8.membrane.core.graphql.model.FragmentSpread;
import com.predic8.membrane.core.graphql.model.InlineFragment;
import com.predic8.membrane.core.graphql.model.OperationDefinition;
import com.predic8.membrane.core.graphql.model.Selection;
import com.predic8.membrane.core.http.HeaderField;
import com.predic8.membrane.core.http.HeaderName;
import com.predic8.membrane.core.util.URLParamUtil;
import jakarta.mail.internet.ContentType;
import jakarta.mail.internet.ParseException;
import java.io.ByteArrayInputStream;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQLoverHttpValidator {
    private static final Logger log = LoggerFactory.getLogger(GraphQLoverHttpValidator.class);
    public static final String EXTENSIONS = "extensions";
    public static final String VARIABLES = "variables";
    public static final String MUTATION = "mutation";
    public static final String QUERY = "query";
    public static final String OPERATION_NAME = "operationName";
    private final GraphQLParser graphQLParser = new GraphQLParser();
    private final ObjectMapper om = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_READING_DUP_TREE_KEY, true).configure(JsonParser.Feature.STRICT_DUPLICATE_DETECTION, true);
    private final boolean allowExtensions;
    private final List<String> allowedMethods;
    private final int maxRecursion;
    private final int maxDepth;
    private final int maxMutations;
    private final Router router;
    private final FeatureBlocklist featureBlocklist;

    public GraphQLoverHttpValidator(boolean allowExtensions, List<String> allowedMethods, int maxRecursion, int maxDepth, int maxMutations, FeatureBlocklist featureBlocklist, Router router) {
        this.allowExtensions = allowExtensions;
        this.allowedMethods = allowedMethods;
        this.maxRecursion = maxRecursion;
        this.maxDepth = maxDepth;
        this.maxMutations = maxMutations;
        this.featureBlocklist = featureBlocklist;
        this.router = router;
    }

    public void validate(Exchange exc) throws GraphQLOverHttpValidationException {
        if (!this.allowedMethods.contains(exc.getRequest().getMethod())) {
            throw new GraphQLOverHttpValidationException(405, "Invalid method.");
        }
        Map<String, Object> data = this.getData(exc);
        this.checkExtensions(data);
        GraphQLoverHttpValidator.checkVariables(data);
        GraphQLoverHttpValidator.checkExtension(data);
        ExecutableDocument ed = this.getExecutableDocument(GraphQLoverHttpValidator.getQuery(data));
        if (this.featureBlocklist != null) {
            this.featureBlocklist.checkFilters(ed);
        }
        this.checkMutations(ed);
        GraphQLoverHttpValidator.validate(ed);
        this.checkThatGetIsUsedOnlyForQueries(exc, ed);
        this.checkDepthOrRecursion(ed, GraphQLoverHttpValidator.getOperationName(data));
    }

    private void checkThatGetIsUsedOnlyForQueries(Exchange exc, ExecutableDocument ed) {
        if (!exc.getRequest().isGETRequest()) {
            return;
        }
        if (ed.getOperationDefinitions().stream().anyMatch(od -> od.getOperationType() != null && !QUERY.equals(od.getOperationType().getOperation()))) {
            throw new GraphQLOverHttpValidationException(405, "'GET' may only be used for GraphQL 'query's.");
        }
    }

    @NotNull
    private static Predicate<ExecutableDefinition> isOperationDefinition() {
        return exd -> exd instanceof OperationDefinition;
    }

    private void checkMutations(ExecutableDocument ed) {
        if (GraphQLoverHttpValidator.countMutations(ed.getExecutableDefinitions()) > this.maxMutations) {
            throw new GraphQLOverHttpValidationException("Too many mutations defined in document.");
        }
    }

    private void checkExtensions(Map<String, Object> data) {
        if (!this.allowExtensions && data.containsKey(EXTENSIONS) && data.get(EXTENSIONS) != null) {
            throw new GraphQLOverHttpValidationException("GraphQL 'extensions' are forbidden.");
        }
    }

    @NotNull
    private Map<String, Object> getData(Exchange exc) {
        if (exc.getRequest().isGETRequest()) {
            return this.getData(this.getRawQuery(exc));
        }
        if (exc.getRequest().isPOSTRequest()) {
            return this.getDataPost(exc, this.getRawQuery(exc));
        }
        throw new IllegalStateException("Should never get here");
    }

    private void checkDepthOrRecursion(ExecutableDocument ed, Object operationName) {
        String depthOrRecursionError = this.getDepthOrRecursionError(ed, GraphQLoverHttpValidator.getOperationDefinition(operationName, ed));
        if (depthOrRecursionError != null) {
            throw new GraphQLOverHttpValidationException(depthOrRecursionError);
        }
    }

    @Nullable
    private static Object getOperationName(Map data) {
        Object operationName = data.get(OPERATION_NAME);
        if (operationName != null && !(operationName instanceof String)) {
            throw new GraphQLOverHttpValidationException("Expected 'operationName' to be a String.");
        }
        return operationName;
    }

    private static void checkVariables(Map data) {
        Object variables = data.get(VARIABLES);
        if (variables != null && !(variables instanceof Map)) {
            throw new GraphQLOverHttpValidationException("Expected 'variables' to be a JSON Object.");
        }
    }

    private static void validate(ExecutableDocument ed) {
        List<String> e1 = new GraphQLValidator().validate(ed);
        if (e1 != null && !e1.isEmpty()) {
            throw new GraphQLOverHttpValidationException(e1.get(0));
        }
    }

    private static OperationDefinition getOperationDefinition(Object operationName, ExecutableDocument ed) {
        if (operationName != null && !operationName.equals("")) {
            List<OperationDefinition> ods = ed.getOperationDefinitionsByName(operationName);
            if (ods.isEmpty()) {
                throw new GraphQLOverHttpValidationException("The operation named by 'operationName' could not be found.");
            }
            if (ods.size() > 1) {
                throw new GraphQLOverHttpValidationException("Multiple OperationDefinitions with the same name in the GraphQL document.");
            }
            return ods.get(0);
        }
        List<OperationDefinition> ods = ed.getOperationDefinitions();
        if (ods.isEmpty()) {
            throw new GraphQLOverHttpValidationException("Could not find an OperationDefinition in the GraphQL document.");
        }
        return ods.get(0);
    }

    private ExecutableDocument getExecutableDocument(String query) {
        try {
            return this.graphQLParser.parseRequest(new ByteArrayInputStream(query.getBytes(StandardCharsets.UTF_8)));
        }
        catch (Exception e) {
            log.debug("Error parsing GraphQL request", (Throwable)e);
            throw new GraphQLOverHttpValidationException(422, "Error parsing GraphQL request.");
        }
    }

    private static void checkExtension(Map data) {
        Object extensions = data.get(EXTENSIONS);
        if (extensions == null) {
            return;
        }
        if (!(extensions instanceof Map)) {
            throw new GraphQLOverHttpValidationException("Expected 'extensions' to be a JSON Object.");
        }
    }

    @NotNull
    private static String getQuery(Map data) {
        Object query = data.get(QUERY);
        if (query == null) {
            throw new GraphQLOverHttpValidationException("Parameter 'query' is missing.");
        }
        if (!(query instanceof String)) {
            throw new GraphQLOverHttpValidationException("Expected 'query' to be of type 'String'.");
        }
        return (String)query;
    }

    @NotNull
    private Map<String, Object> getDataPost(Exchange exc, String rawQuery) {
        ContentType ct;
        if (rawQuery != null) {
            Map<String, String> params = URLParamUtil.parseQueryString(rawQuery, URLParamUtil.DuplicateKeyOrInvalidFormStrategy.ERROR);
            for (String key : new String[]{QUERY, OPERATION_NAME, VARIABLES, EXTENSIONS}) {
                if (!params.containsKey(key)) continue;
                throw new GraphQLOverHttpValidationException("'" + key + "' is not allowed as query parameter while using POST.");
            }
        }
        if ((ct = GraphQLoverHttpValidator.getContentType2(exc)).match("application/graphql")) {
            return ImmutableMap.of((Object)QUERY, (Object)exc.getRequest().getBodyAsStringDecoded());
        }
        if (ct.match("application/json")) {
            String charset = ct.getParameter("charset");
            if (charset != null && !"utf-8".equalsIgnoreCase(charset)) {
                throw new GraphQLOverHttpValidationException("Invalid charset in 'Content-Type': Expected 'utf-8'.");
            }
            try {
                return (Map)this.om.readValue(exc.getRequest().getBodyAsStreamDecoded(), Map.class);
            }
            catch (Exception e) {
                throw new GraphQLOverHttpValidationException("Error decoding JSON object.");
            }
        }
        throw new GraphQLOverHttpValidationException("Expected 'Content-Type: application/json' or 'Content-Type: application/graphql'.");
    }

    @NotNull
    private static ContentType getContentType2(Exchange exc) {
        List<HeaderField> contentType = exc.getRequest().getHeader().getValues(new HeaderName("Content-Type"));
        if (contentType.isEmpty()) {
            throw new GraphQLOverHttpValidationException("No 'Content-Type' found.");
        }
        if (contentType.size() > 1) {
            throw new GraphQLOverHttpValidationException("Found multiple 'Content-Type' headers.");
        }
        return GraphQLoverHttpValidator.getContentType(contentType);
    }

    @NotNull
    private static ContentType getContentType(List<HeaderField> contentType) {
        try {
            return new ContentType(contentType.get(0).getValue());
        }
        catch (ParseException e) {
            throw new GraphQLOverHttpValidationException("Could not parse 'Content-Type' header.");
        }
    }

    private String getRawQuery(Exchange exc) {
        try {
            return this.router.getUriFactory().create(exc.getRequest().getUri()).getRawQuery();
        }
        catch (URISyntaxException e) {
            throw new GraphQLOverHttpValidationException(400, "Invalid request URI.");
        }
    }

    @NotNull
    private Map<String, Object> getData(String rawQuery) {
        Map<String, Object> data;
        if (rawQuery == null) {
            throw new GraphQLOverHttpValidationException("No query parameters found.");
        }
        try {
            data = URLParamUtil.parseQueryString(rawQuery, URLParamUtil.DuplicateKeyOrInvalidFormStrategy.ERROR);
        }
        catch (Exception e) {
            throw new GraphQLOverHttpValidationException("Error decoding query string.");
        }
        try {
            if (data.containsKey(VARIABLES)) {
                data.put(VARIABLES, this.om.readValue((String)data.get(VARIABLES), Map.class));
            }
            if (data.containsKey(EXTENSIONS)) {
                data.put(EXTENSIONS, this.om.readValue((String)data.get(EXTENSIONS), Map.class));
            }
            return data;
        }
        catch (JsonProcessingException e) {
            throw new GraphQLOverHttpValidationException(422, "Error parsing variables or extensions from request JSON.");
        }
    }

    public static int countMutations(List<ExecutableDefinition> definitions) {
        return (int)GraphQLoverHttpValidator.getMutationOperations(definitions).map(OperationDefinition::getSelections).mapToLong(List::size).sum();
    }

    @NotNull
    public static Stream<OperationDefinition> getMutationOperations(List<ExecutableDefinition> definitions) {
        return definitions.stream().filter(GraphQLoverHttpValidator.isOperationDefinition()).map(definition -> (OperationDefinition)definition).filter(operation -> operation.getOperationType() != null).filter(GraphQLoverHttpValidator::isMutation);
    }

    private static boolean isMutation(OperationDefinition operation) {
        return operation.getOperationType().getOperation().equals(MUTATION);
    }

    private String getDepthOrRecursionError(ExecutableDocument ed, OperationDefinition od) {
        return this.checkSelections(ed, od, od.getSelections(), new ArrayList<String>(), new HashSet<String>());
    }

    private String checkSelections(ExecutableDocument ed, OperationDefinition od, List<Selection> selections, List<String> fieldStack, HashSet<String> fragmentNamesVisited) {
        if (selections == null) {
            return null;
        }
        Iterator<Selection> iterator = selections.iterator();
        if (iterator.hasNext()) {
            Selection selection = iterator.next();
            if (selection == null) {
                log.error("Selection is null.");
                return "See server log.";
            }
            if (selection instanceof Field) {
                return this.checkField((Field)selection, ed, od, fieldStack, fragmentNamesVisited);
            }
            if (selection instanceof FragmentSpread) {
                return this.checkFragmentSpread((FragmentSpread)selection, ed, od, fieldStack, fragmentNamesVisited);
            }
            if (selection instanceof InlineFragment) {
                return this.checkSelections(ed, od, ((InlineFragment)selection).getSelections(), fieldStack, fragmentNamesVisited);
            }
            return this.checkUnhandled(selection);
        }
        return null;
    }

    private String checkUnhandled(Selection selection) {
        log.error("Unhandled class: " + selection.getClass().getName());
        return "See server log.";
    }

    private String checkFragmentSpread(FragmentSpread fragmentSpread, ExecutableDocument ed, OperationDefinition od, List<String> fieldStack, HashSet<String> fragmentNamesVisited) {
        String fragmentName = fragmentSpread.getFragmentName();
        Optional<FragmentDefinition> fragment = ed.getExecutableDefinitions().stream().filter(ed2 -> ed2 instanceof FragmentDefinition).map(ed2 -> (FragmentDefinition)ed2).filter(ed2 -> fragmentName.equals(ed2.getName())).findAny();
        if (fragment.isEmpty()) {
            return "Did not find fragment '" + fragmentName + "'.";
        }
        if (!fragmentNamesVisited.add(fragmentName)) {
            return "Fragment spreads form cycle ('" + fragmentName + "').";
        }
        String err = this.checkSelections(ed, od, fragment.get().getSelections(), fieldStack, fragmentNamesVisited);
        if (err != null) {
            return err;
        }
        fragmentNamesVisited.remove(fragmentName);
        return null;
    }

    private String checkField(Field field, ExecutableDocument ed, OperationDefinition od, List<String> fieldStack, HashSet<String> fragmentNamesVisited) {
        String fieldName = field.getName();
        fieldStack.add(fieldName);
        if (fieldStack.size() > this.maxDepth) {
            return "Max depth exceeded.";
        }
        if (fieldStack.stream().filter(name -> name.equals(fieldName)).count() > (long)this.maxRecursion) {
            return "Max recursion exceeded.";
        }
        String err = this.checkSelections(ed, od, field.getSelections(), fieldStack, fragmentNamesVisited);
        if (err != null) {
            return err;
        }
        fieldStack.remove(fieldStack.size() - 1);
        return null;
    }
}

