/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.graphql.blocklist.filters;

import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.graphql.GraphQLOverHttpValidationException;
import com.predic8.membrane.core.graphql.blocklist.filters.GraphQLFeatureFilter;
import com.predic8.membrane.core.graphql.model.ExecutableDocument;
import com.predic8.membrane.core.graphql.model.Field;
import com.predic8.membrane.core.graphql.model.InlineFragment;
import com.predic8.membrane.core.graphql.model.Selection;
import java.util.List;

@MCElement(name="introspection")
public class IntrospectionFilter
implements GraphQLFeatureFilter {
    @Override
    public void filter(ExecutableDocument ed) throws GraphQLOverHttpValidationException {
        ed.getOperationDefinitions().forEach(operation -> this.checkSelections(operation.getSelections()));
    }

    private void checkSelections(List<Selection> selections) throws GraphQLOverHttpValidationException {
        selections.forEach(selection -> {
            if (selection instanceof Field) {
                Field f = (Field)selection;
                if (f.getName().startsWith("__")) {
                    throw new GraphQLOverHttpValidationException("Introspection is not permitted.");
                }
                this.checkSelections(f.getSelections());
            } else if (selection instanceof InlineFragment) {
                this.checkSelections(((InlineFragment)selection).getSelections());
            }
        });
    }
}

