/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.graphql.blocklist.filters;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.graphql.GraphQLOverHttpValidationException;
import com.predic8.membrane.core.graphql.GraphQLoverHttpValidator;
import com.predic8.membrane.core.graphql.blocklist.filters.GraphQLFeatureFilter;
import com.predic8.membrane.core.graphql.model.ExecutableDocument;
import com.predic8.membrane.core.graphql.model.Field;
import com.predic8.membrane.core.graphql.model.Selection;
import java.util.List;

@MCElement(name="mutation")
public class MutationFilter
implements GraphQLFeatureFilter {
    private String name;

    @Override
    public void filter(ExecutableDocument ed) throws GraphQLOverHttpValidationException {
        GraphQLoverHttpValidator.getMutationOperations(ed.getExecutableDefinitions()).forEach(mutation -> this.checkMutationSelections(mutation.getSelections()));
    }

    private void checkMutationSelections(List<Selection> selections) throws GraphQLOverHttpValidationException {
        selections.forEach(selection -> {
            Field field;
            if (selection instanceof Field && (field = (Field)selection).getName().equals(this.name)) {
                throw new GraphQLOverHttpValidationException("Mutation \"" + this.name + "\" not permitted.");
            }
        });
    }

    @MCAttribute
    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }
}

