/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.graphql.model;

import com.predic8.membrane.core.graphql.ParserUtil;
import com.predic8.membrane.core.graphql.ParsingException;
import com.predic8.membrane.core.graphql.Tokenizer;
import com.predic8.membrane.core.graphql.model.Argument;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public class Directive {
    private String name;
    private List<Argument> arguments;

    public Directive() {
    }

    public Directive(String name) {
        this.name = name;
    }

    public Directive(String name, List<Argument> arguments) {
        this.name = name;
        this.arguments = arguments;
    }

    public void parse(Tokenizer t) throws IOException, ParsingException {
        this.name = ParserUtil.parseName(t);
        if (t.advance()) {
            this.arguments = ParserUtil.parseOptionalArguments(t);
            if (this.arguments == null) {
                t.revert();
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Directive directive = (Directive)o;
        return Objects.equals(this.name, directive.name) && Objects.equals(this.arguments, directive.arguments);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.arguments);
    }

    public String toString() {
        return "Directive{name='" + this.name + "', arguments=" + String.valueOf(this.arguments) + "}";
    }
}

