/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.graphql.model;

import com.predic8.membrane.core.graphql.ParserUtil;
import com.predic8.membrane.core.graphql.ParsingException;
import com.predic8.membrane.core.graphql.Tokenizer;
import com.predic8.membrane.core.graphql.model.DirectiveLocation;
import com.predic8.membrane.core.graphql.model.InputValueDefinition;
import com.predic8.membrane.core.graphql.model.TypeSystemDefinition;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DirectiveDefinition
implements TypeSystemDefinition {
    private String description;
    private String name;
    private List<InputValueDefinition> inputValueDefinitions;
    private boolean repeatable;
    private List<DirectiveLocation> directiveLocations;

    public DirectiveDefinition() {
    }

    public DirectiveDefinition(String description, String name, List<InputValueDefinition> inputValueDefinitions, boolean repeatable, List<DirectiveLocation> directiveLocations) {
        this.description = description;
        this.name = name;
        this.inputValueDefinitions = inputValueDefinitions;
        this.repeatable = repeatable;
        this.directiveLocations = directiveLocations;
    }

    @Override
    public void parse(Tokenizer tokenizer) throws IOException, ParsingException {
        tokenizer.mustAdvance();
        if (tokenizer.type() != Tokenizer.Type.PUNCTUATOR || tokenizer.punctuator() != 64) {
            throw new ParsingException("Expected '@'.", tokenizer.position());
        }
        this.name = ParserUtil.parseName(tokenizer);
        tokenizer.mustAdvance();
        this.inputValueDefinitions = ParserUtil.parseOptionalArgumentsDefinition(tokenizer);
        if (this.inputValueDefinitions != null) {
            tokenizer.mustAdvance();
        }
        if (tokenizer.type() == Tokenizer.Type.NAME && tokenizer.string().equals("repeatable")) {
            this.repeatable = true;
            tokenizer.mustAdvance();
        }
        if (tokenizer.type() != Tokenizer.Type.NAME || !tokenizer.string().equals("on")) {
            throw new ParsingException("Expected 'on'.", tokenizer.position());
        }
        this.directiveLocations = DirectiveDefinition.parseDirectiveLocations(tokenizer);
        tokenizer.revert();
    }

    public static List<DirectiveLocation> parseDirectiveLocations(Tokenizer tokenizer) throws IOException, ParsingException {
        tokenizer.mustAdvance();
        if (tokenizer.type() == Tokenizer.Type.PUNCTUATOR && tokenizer.punctuator() == 124) {
            tokenizer.mustAdvance();
        }
        ArrayList<DirectiveLocation> res = new ArrayList<DirectiveLocation>();
        while (true) {
            DirectiveLocation type = DirectiveLocation.parseDirectiveLocation(tokenizer);
            res.add(type);
            if (!tokenizer.advance() || tokenizer.type() != Tokenizer.Type.PUNCTUATOR || tokenizer.punctuator() != 124) break;
            tokenizer.mustAdvance();
        }
        return res;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DirectiveDefinition that = (DirectiveDefinition)o;
        return this.repeatable == that.repeatable && Objects.equals(this.description, that.description) && Objects.equals(this.name, that.name) && Objects.equals(this.inputValueDefinitions, that.inputValueDefinitions) && Objects.equals(this.directiveLocations, that.directiveLocations);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.name, this.inputValueDefinitions, this.repeatable, this.directiveLocations);
    }

    public String toString() {
        return "DirectiveDefinition{description='" + this.description + "', name='" + this.name + "', inputValueDefinitions=" + String.valueOf(this.inputValueDefinitions) + ", repeatable=" + this.repeatable + ", directiveLocations=" + String.valueOf(this.directiveLocations) + "}";
    }
}

