/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.graphql.model;

import com.predic8.membrane.core.graphql.ParserUtil;
import com.predic8.membrane.core.graphql.ParsingException;
import com.predic8.membrane.core.graphql.Tokenizer;
import com.predic8.membrane.core.graphql.model.Directive;
import com.predic8.membrane.core.graphql.model.EnumValueDefinition;
import com.predic8.membrane.core.graphql.model.TypeSystemDefinition;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class EnumTypeDefinition
implements TypeSystemDefinition {
    private String description;
    private String name;
    private List<Directive> directives;
    private List<EnumValueDefinition> enumValueDefinitions = new ArrayList<EnumValueDefinition>();

    public EnumTypeDefinition() {
    }

    public EnumTypeDefinition(String description, String name, List<Directive> directives, List<EnumValueDefinition> enumValueDefinitions) {
        this.description = description;
        this.name = name;
        this.directives = directives;
        this.enumValueDefinitions = enumValueDefinitions;
    }

    @Override
    public void parse(Tokenizer tokenizer) throws IOException, ParsingException {
        this.name = ParserUtil.parseName(tokenizer);
        if (!tokenizer.advance()) {
            return;
        }
        this.directives = ParserUtil.parseDirectivesConstOpt(tokenizer);
        if (this.directives != null && !tokenizer.advance()) {
            return;
        }
        if (tokenizer.type() == Tokenizer.Type.PUNCTUATOR && tokenizer.integer() == 123) {
            this.parseEnumValuesDefinition(tokenizer);
            return;
        }
        tokenizer.revert();
    }

    private void parseEnumValuesDefinition(Tokenizer tokenizer) throws IOException, ParsingException {
        tokenizer.mustAdvance();
        do {
            if (tokenizer.type() == Tokenizer.Type.PUNCTUATOR && tokenizer.punctuator() == 125) {
                return;
            }
            EnumValueDefinition evd = new EnumValueDefinition();
            evd.parse(tokenizer);
            this.enumValueDefinitions.add(evd);
        } while (tokenizer.advance());
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnumTypeDefinition that = (EnumTypeDefinition)o;
        return Objects.equals(this.description, that.description) && Objects.equals(this.name, that.name) && Objects.equals(this.directives, that.directives) && Objects.equals(this.enumValueDefinitions, that.enumValueDefinitions);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.name, this.directives, this.enumValueDefinitions);
    }

    public String toString() {
        return "EnumTypeDefinition{description='" + this.description + "', name='" + this.name + "', directives=" + String.valueOf(this.directives) + ", enumValueDefinitions=" + String.valueOf(this.enumValueDefinitions) + "}";
    }
}

