/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.graphql.model;

import com.predic8.membrane.core.graphql.ParserUtil;
import com.predic8.membrane.core.graphql.ParsingException;
import com.predic8.membrane.core.graphql.Tokenizer;
import com.predic8.membrane.core.graphql.model.Directive;
import com.predic8.membrane.core.graphql.model.InputValueDefinition;
import com.predic8.membrane.core.graphql.model.Type;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public class FieldDefinition {
    String description;
    private String name;
    private List<InputValueDefinition> inputValueDefinitions;
    private Type type;
    private List<Directive> directives;

    public FieldDefinition() {
    }

    public FieldDefinition(String description, String name, List<InputValueDefinition> inputValueDefinitions, Type type, List<Directive> directives) {
        this.description = description;
        this.name = name;
        this.inputValueDefinitions = inputValueDefinitions;
        this.type = type;
        this.directives = directives;
    }

    public void parse(Tokenizer tokenizer) throws IOException, ParsingException {
        if (tokenizer.type() == Tokenizer.Type.STRING_VALUE) {
            this.description = tokenizer.string();
            tokenizer.mustAdvance();
        }
        if (tokenizer.type() != Tokenizer.Type.NAME) {
            throw new ParsingException("Expected field name.", tokenizer.position());
        }
        this.name = tokenizer.string();
        tokenizer.mustAdvance();
        this.inputValueDefinitions = ParserUtil.parseOptionalArgumentsDefinition(tokenizer);
        if (this.inputValueDefinitions != null) {
            tokenizer.mustAdvance();
        }
        if (tokenizer.type() != Tokenizer.Type.PUNCTUATOR || tokenizer.punctuator() != 58) {
            throw new ParsingException("Expected ':'.", tokenizer.position());
        }
        tokenizer.mustAdvance();
        this.type = ParserUtil.parseType(tokenizer);
        if (!tokenizer.advance()) {
            return;
        }
        this.directives = ParserUtil.parseDirectivesConstOpt(tokenizer);
        if (this.directives == null) {
            tokenizer.revert();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldDefinition that = (FieldDefinition)o;
        return Objects.equals(this.description, that.description) && Objects.equals(this.name, that.name) && Objects.equals(this.inputValueDefinitions, that.inputValueDefinitions) && Objects.equals(this.type, that.type) && Objects.equals(this.directives, that.directives);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.name, this.inputValueDefinitions, this.type, this.directives);
    }

    public String toString() {
        return "FieldDefinition{description='" + this.description + "', name='" + this.name + "', inputValueDefinitions=" + String.valueOf(this.inputValueDefinitions) + ", type=" + String.valueOf(this.type) + ", directives=" + String.valueOf(this.directives) + "}";
    }
}

