/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.graphql.model;

import com.predic8.membrane.core.graphql.ParserUtil;
import com.predic8.membrane.core.graphql.ParsingException;
import com.predic8.membrane.core.graphql.Tokenizer;
import com.predic8.membrane.core.graphql.model.Directive;
import com.predic8.membrane.core.graphql.model.Selection;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public class FragmentSpread
extends Selection {
    private String fragmentName;
    private List<Directive> directives;

    public FragmentSpread() {
    }

    public FragmentSpread(String fragmentName, List<Directive> directives) {
        this.fragmentName = fragmentName;
        this.directives = directives;
    }

    @Override
    public void parse(Tokenizer tokenizer) throws IOException, ParsingException {
        if (tokenizer.type() != Tokenizer.Type.NAME) {
            throw new ParsingException("Expected name.", tokenizer.position());
        }
        this.fragmentName = tokenizer.string();
        if ("on".equals(this.fragmentName)) {
            throw new ParsingException("FragmentName may not be 'on'.", tokenizer.position());
        }
        if (!tokenizer.advance()) {
            return;
        }
        this.directives = ParserUtil.parseDirectivesOpt(tokenizer);
        if (this.directives == null) {
            tokenizer.revert();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FragmentSpread that = (FragmentSpread)o;
        return Objects.equals(this.fragmentName, that.fragmentName) && Objects.equals(this.directives, that.directives);
    }

    public int hashCode() {
        return Objects.hash(this.fragmentName, this.directives);
    }

    public String toString() {
        return "FragmentSpread{fragmentName='" + this.fragmentName + "', directives=" + String.valueOf(this.directives) + "}";
    }

    public String getFragmentName() {
        return this.fragmentName;
    }
}

