/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.graphql.model;

import com.predic8.membrane.core.graphql.ParserUtil;
import com.predic8.membrane.core.graphql.ParsingException;
import com.predic8.membrane.core.graphql.Tokenizer;
import com.predic8.membrane.core.graphql.model.Directive;
import com.predic8.membrane.core.graphql.model.Selection;
import com.predic8.membrane.core.graphql.model.Type;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public class InlineFragment
extends Selection {
    Type condition;
    List<Directive> directives;
    List<Selection> selections;

    public InlineFragment() {
    }

    public InlineFragment(Type condition, List<Directive> directives, List<Selection> selections) {
        this.condition = condition;
        this.directives = directives;
        this.selections = selections;
    }

    @Override
    public void parse(Tokenizer tokenizer) throws IOException, ParsingException {
        if (tokenizer.type() == Tokenizer.Type.NAME && tokenizer.string().equals("on")) {
            tokenizer.mustAdvance();
            this.condition = ParserUtil.parseType(tokenizer);
            tokenizer.mustAdvance();
        }
        this.directives = ParserUtil.parseDirectivesOpt(tokenizer);
        if (this.directives != null) {
            tokenizer.mustAdvance();
        }
        if (tokenizer.type() != Tokenizer.Type.PUNCTUATOR || tokenizer.punctuator() != 123) {
            throw new ParsingException("Expected '{'.", tokenizer.position());
        }
        this.selections = ParserUtil.parseSelectionSetOpt(tokenizer);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InlineFragment that = (InlineFragment)o;
        return Objects.equals(this.condition, that.condition) && Objects.equals(this.directives, that.directives) && Objects.equals(this.selections, that.selections);
    }

    public int hashCode() {
        return Objects.hash(this.condition, this.directives, this.selections);
    }

    public String toString() {
        return "InlineFragment{condition=" + String.valueOf(this.condition) + ", directives=" + String.valueOf(this.directives) + ", selections=" + String.valueOf(this.selections) + "}";
    }

    public List<Selection> getSelections() {
        return this.selections;
    }
}

