/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.graphql.model;

import com.predic8.membrane.core.graphql.ParserUtil;
import com.predic8.membrane.core.graphql.ParsingException;
import com.predic8.membrane.core.graphql.Tokenizer;
import com.predic8.membrane.core.graphql.model.Directive;
import com.predic8.membrane.core.graphql.model.InputValueDefinition;
import com.predic8.membrane.core.graphql.model.TypeSystemDefinition;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class InputObjectTypeDefinition
implements TypeSystemDefinition {
    private String description;
    private String name;
    private List<Directive> directives;
    private List<InputValueDefinition> inputValueDefinitions = new ArrayList<InputValueDefinition>();

    public InputObjectTypeDefinition() {
    }

    public InputObjectTypeDefinition(String description, String name, List<Directive> directives, List<InputValueDefinition> inputValueDefinitions) {
        this.description = description;
        this.name = name;
        this.directives = directives;
        this.inputValueDefinitions = inputValueDefinitions;
    }

    @Override
    public void parse(Tokenizer tokenizer) throws IOException, ParsingException {
        this.name = ParserUtil.parseName(tokenizer);
        if (!tokenizer.advance()) {
            return;
        }
        this.directives = ParserUtil.parseDirectivesConstOpt(tokenizer);
        if (this.directives != null && !tokenizer.advance()) {
            return;
        }
        if (tokenizer.type() == Tokenizer.Type.PUNCTUATOR && tokenizer.integer() == 123) {
            this.parseInputFieldsDefinition(tokenizer);
            return;
        }
        tokenizer.revert();
    }

    private void parseInputFieldsDefinition(Tokenizer tokenizer) throws IOException, ParsingException {
        tokenizer.mustAdvance();
        do {
            if (tokenizer.type() == Tokenizer.Type.PUNCTUATOR && tokenizer.punctuator() == 125) {
                return;
            }
            InputValueDefinition ivd = new InputValueDefinition();
            ivd.parse(tokenizer);
            this.inputValueDefinitions.add(ivd);
        } while (tokenizer.advance());
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InputObjectTypeDefinition that = (InputObjectTypeDefinition)o;
        return Objects.equals(this.description, that.description) && Objects.equals(this.name, that.name) && Objects.equals(this.directives, that.directives) && Objects.equals(this.inputValueDefinitions, that.inputValueDefinitions);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.name, this.directives, this.inputValueDefinitions);
    }

    public String toString() {
        return "InputObjectTypeDefinition{description='" + this.description + "', name='" + this.name + "', directives=" + String.valueOf(this.directives) + ", inputValueDefinitions=" + String.valueOf(this.inputValueDefinitions) + "}";
    }
}

