/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.graphql.model;

import com.predic8.membrane.core.graphql.ParserUtil;
import com.predic8.membrane.core.graphql.ParsingException;
import com.predic8.membrane.core.graphql.Tokenizer;
import com.predic8.membrane.core.graphql.model.Directive;
import com.predic8.membrane.core.graphql.model.Type;
import com.predic8.membrane.core.graphql.model.Value;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public class InputValueDefinition {
    String description;
    String name;
    Type type;
    Value defaultValue;
    private List<Directive> directives;

    public InputValueDefinition() {
    }

    public InputValueDefinition(String description, String name, Type type, Value defaultValue, List<Directive> directives) {
        this.description = description;
        this.name = name;
        this.type = type;
        this.defaultValue = defaultValue;
        this.directives = directives;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InputValueDefinition that = (InputValueDefinition)o;
        return Objects.equals(this.description, that.description) && Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type) && Objects.equals(this.defaultValue, that.defaultValue) && Objects.equals(this.directives, that.directives);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.name, this.type, this.defaultValue, this.directives);
    }

    public String toString() {
        return "InputValueDefinition{description='" + this.description + "', name='" + this.name + "', type=" + String.valueOf(this.type) + ", defaultValue=" + String.valueOf(this.defaultValue) + ", directives=" + String.valueOf(this.directives) + "}";
    }

    public void parse(Tokenizer t) throws IOException, ParsingException {
        if (t.type() == Tokenizer.Type.STRING_VALUE) {
            this.description = t.string();
            t.mustAdvance();
        }
        if (t.type() != Tokenizer.Type.NAME) {
            throw new ParsingException("Expected name.", t.position());
        }
        this.name = t.string();
        t.mustAdvance();
        if (t.type() != Tokenizer.Type.PUNCTUATOR || t.punctuator() != 58) {
            throw new ParsingException("Expected ':'.", t.position());
        }
        t.mustAdvance();
        this.type = ParserUtil.parseType(t);
        if (!t.advance()) {
            return;
        }
        if (t.type() == Tokenizer.Type.PUNCTUATOR && t.punctuator() == 61) {
            t.mustAdvance();
            this.defaultValue = ParserUtil.parseValueConst(t);
            if (!t.advance()) {
                return;
            }
        }
        this.directives = ParserUtil.parseDirectivesConstOpt(t);
        if (this.directives == null) {
            t.revert();
        }
    }
}

