/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.graphql.model;

import com.predic8.membrane.core.graphql.ParserUtil;
import com.predic8.membrane.core.graphql.ParsingException;
import com.predic8.membrane.core.graphql.Tokenizer;
import com.predic8.membrane.core.graphql.model.Type;
import java.io.IOException;
import java.util.Objects;

public class ListType
extends Type {
    Type type;
    boolean nullable;

    public ListType() {
    }

    public ListType(Type type) {
        this.type = type;
    }

    public ListType(Type type, boolean nullable) {
        this.type = type;
        this.nullable = nullable;
    }

    @Override
    public void parse(Tokenizer tokenizer) throws IOException, ParsingException {
        tokenizer.mustAdvance();
        this.type = ParserUtil.parseType(tokenizer);
        tokenizer.mustAdvance();
        if (tokenizer.type() != Tokenizer.Type.PUNCTUATOR || tokenizer.punctuator() != 93) {
            throw new ParsingException("Expected ']'.", tokenizer.position());
        }
        if (!tokenizer.advance()) {
            return;
        }
        if (tokenizer.type() == Tokenizer.Type.PUNCTUATOR && tokenizer.punctuator() == 33) {
            this.nullable = true;
        } else {
            tokenizer.revert();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListType listType = (ListType)o;
        return this.nullable == listType.nullable && Objects.equals(this.type, listType.type);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.nullable);
    }

    public String toString() {
        return "ListType{type=" + String.valueOf(this.type) + ", nullable=" + this.nullable + "}";
    }
}

