/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.graphql.model;

import com.predic8.membrane.core.graphql.ParsingException;
import com.predic8.membrane.core.graphql.Tokenizer;
import com.predic8.membrane.core.graphql.model.Type;
import java.io.IOException;
import java.util.Objects;

public class NamedType
extends Type {
    String name;
    boolean nullable;

    public NamedType() {
    }

    public NamedType(String name) {
        this.name = name;
    }

    public NamedType(String name, boolean nullable) {
        this.name = name;
        this.nullable = nullable;
    }

    @Override
    public void parse(Tokenizer tokenizer) throws IOException, ParsingException {
        this.name = tokenizer.string();
        if (!tokenizer.advance()) {
            return;
        }
        if (tokenizer.type() == Tokenizer.Type.PUNCTUATOR && tokenizer.punctuator() == 33) {
            this.nullable = true;
        } else {
            tokenizer.revert();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NamedType namedType = (NamedType)o;
        return this.nullable == namedType.nullable && Objects.equals(this.name, namedType.name);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.nullable);
    }

    public String toString() {
        return "NamedType{name='" + this.name + "', nullable=" + this.nullable + "}";
    }

    public boolean isNullable() {
        return this.nullable;
    }
}

