/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.graphql.model;

import com.predic8.membrane.core.graphql.ParserUtil;
import com.predic8.membrane.core.graphql.ParsingException;
import com.predic8.membrane.core.graphql.Tokenizer;
import com.predic8.membrane.core.graphql.model.Value;
import java.io.IOException;
import java.util.Objects;

public class ObjectField {
    private String name;
    private Value value;

    public ObjectField() {
    }

    public ObjectField(String name, Value value) {
        this.name = name;
        this.value = value;
    }

    public void parse(Tokenizer tokenizer) throws IOException, ParsingException {
        tokenizer.revert();
        this.name = ParserUtil.parseName(tokenizer);
        tokenizer.mustAdvance();
        if (tokenizer.type() != Tokenizer.Type.PUNCTUATOR || tokenizer.punctuator() != 58) {
            throw new ParsingException("Expected ':'.", tokenizer.position());
        }
        tokenizer.mustAdvance();
        this.value = ParserUtil.parseValueQuestionConst(tokenizer);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectField field = (ObjectField)o;
        return Objects.equals(this.name, field.name) && Objects.equals(this.value, field.value);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value);
    }

    public String toString() {
        return "ObjectField{name='" + this.name + "', value=" + String.valueOf(this.value) + "}";
    }
}

