/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.graphql.model;

import com.predic8.membrane.core.graphql.ParsingException;
import com.predic8.membrane.core.graphql.Tokenizer;
import com.predic8.membrane.core.graphql.model.DirectiveDefinition;
import com.predic8.membrane.core.graphql.model.EnumTypeDefinition;
import com.predic8.membrane.core.graphql.model.InputObjectTypeDefinition;
import com.predic8.membrane.core.graphql.model.InterfaceTypeDefinition;
import com.predic8.membrane.core.graphql.model.ObjectTypeDefinition;
import com.predic8.membrane.core.graphql.model.ScalarTypeDefinition;
import com.predic8.membrane.core.graphql.model.SchemaDefinition;
import com.predic8.membrane.core.graphql.model.TypeSystemDefinition;
import com.predic8.membrane.core.graphql.model.UnionTypeDefinition;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class TypeSystemDocument {
    List<TypeSystemDefinition> typeSystemDefinitions = new ArrayList<TypeSystemDefinition>();

    public TypeSystemDocument() {
    }

    public TypeSystemDocument(TypeSystemDefinition ... typeSystemDefinitions) {
        this.typeSystemDefinitions.addAll(Arrays.asList(typeSystemDefinitions));
    }

    public void parse(Tokenizer t) throws IOException, ParsingException {
        while (t.advance()) {
            String type;
            String description = null;
            if (t.type() == Tokenizer.Type.STRING_VALUE) {
                description = t.string();
                t.mustAdvance();
            }
            if (t.type() != Tokenizer.Type.NAME) {
                throw new ParsingException("Expected a name.", t.position());
            }
            TypeSystemDefinition typeSystemDefinition = switch (type = t.string()) {
                case "schema" -> new SchemaDefinition();
                case "type" -> new ObjectTypeDefinition();
                case "input" -> new InputObjectTypeDefinition();
                case "scalar" -> new ScalarTypeDefinition();
                case "enum" -> new EnumTypeDefinition();
                case "interface" -> new InterfaceTypeDefinition();
                case "union" -> new UnionTypeDefinition();
                case "directive" -> new DirectiveDefinition();
                default -> throw new ParsingException("Expected 'schema', 'scalar', 'type', 'interface', 'union', 'enum', 'input or 'directive'. Got '" + type + "'.", t.position());
            };
            typeSystemDefinition.parse(t);
            typeSystemDefinition.setDescription(description);
            this.typeSystemDefinitions.add(typeSystemDefinition);
        }
        return;
    }

    public List<TypeSystemDefinition> getDefinitions() {
        return this.typeSystemDefinitions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeSystemDocument that = (TypeSystemDocument)o;
        return this.typeSystemDefinitions.equals(that.typeSystemDefinitions);
    }

    public int hashCode() {
        return Objects.hash(this.typeSystemDefinitions);
    }

    public String toString() {
        return "TypeSystemDocument{typeSystemDefinitions=" + String.valueOf(this.typeSystemDefinitions) + "}";
    }
}

