/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.graphql.model;

import com.predic8.membrane.core.graphql.ParserUtil;
import com.predic8.membrane.core.graphql.ParsingException;
import com.predic8.membrane.core.graphql.Tokenizer;
import com.predic8.membrane.core.graphql.model.Directive;
import com.predic8.membrane.core.graphql.model.NamedType;
import com.predic8.membrane.core.graphql.model.TypeSystemDefinition;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class UnionTypeDefinition
implements TypeSystemDefinition {
    private String description;
    private String name;
    private List<Directive> directives;
    private List<NamedType> unionMemberTypes = new ArrayList<NamedType>();

    public UnionTypeDefinition() {
    }

    public UnionTypeDefinition(String description, String name, List<Directive> directives, List<NamedType> unionMemberTypes) {
        this.description = description;
        this.name = name;
        this.directives = directives;
        this.unionMemberTypes = unionMemberTypes;
    }

    @Override
    public void parse(Tokenizer tokenizer) throws IOException, ParsingException {
        this.name = ParserUtil.parseName(tokenizer);
        if (!tokenizer.advance()) {
            return;
        }
        this.directives = ParserUtil.parseDirectivesConstOpt(tokenizer);
        if (this.directives != null && !tokenizer.advance()) {
            return;
        }
        if (tokenizer.type() == Tokenizer.Type.PUNCTUATOR && tokenizer.integer() == 61) {
            this.unionMemberTypes = ParserUtil.parseUnionMemberTypes(tokenizer);
        }
        tokenizer.revert();
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnionTypeDefinition that = (UnionTypeDefinition)o;
        return Objects.equals(this.description, that.description) && Objects.equals(this.name, that.name) && Objects.equals(this.directives, that.directives) && Objects.equals(this.unionMemberTypes, that.unionMemberTypes);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.name, this.directives, this.unionMemberTypes);
    }

    public String toString() {
        return "UnionTypeDefinition{description='" + this.description + "', name='" + this.name + "', directives=" + String.valueOf(this.directives) + ", unionMemberTypes=" + String.valueOf(this.unionMemberTypes) + "}";
    }
}

