/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.http;

import com.predic8.membrane.core.http.AbstractBodyTransferrer;
import com.predic8.membrane.core.http.BodyInputStream;
import com.predic8.membrane.core.http.Chunk;
import com.predic8.membrane.core.http.Header;
import com.predic8.membrane.core.http.MessageObserver;
import com.predic8.membrane.core.http.NonRelevantBodyObserver;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBody {
    private static final Logger log = LoggerFactory.getLogger((String)AbstractBody.class.getName());
    boolean read;
    protected List<Chunk> chunks = new ArrayList<Chunk>();
    protected List<MessageObserver> observers = new ArrayList<MessageObserver>(1);
    private boolean wasStreamed = false;

    public void read() throws IOException {
        if (this.read) {
            return;
        }
        if (this.wasStreamed) {
            throw new IllegalStateException("Cannot read body after it was streamed.");
        }
        for (MessageObserver observer : this.observers) {
            observer.bodyRequested(this);
        }
        this.chunks.clear();
        this.readLocal();
        this.markAsRead();
    }

    public void discard() throws IOException {
        this.read();
    }

    protected void markAsRead() {
        if (this.read) {
            return;
        }
        this.read = true;
        for (MessageObserver observer : this.observers) {
            observer.bodyComplete(this);
        }
        this.observers.clear();
    }

    protected abstract void readLocal() throws IOException;

    public byte[] getContent() throws IOException {
        this.read();
        byte[] content = new byte[this.getLength()];
        int destPos = 0;
        for (Chunk chunk : this.chunks) {
            destPos = chunk.copyChunk(content, destPos);
        }
        return content;
    }

    public InputStream getContentAsStream() throws IOException {
        this.read();
        return new BodyInputStream(this.chunks);
    }

    public void write(AbstractBodyTransferrer out, boolean retainCopy) throws IOException {
        if (!this.read && !retainCopy) {
            if (this.wasStreamed) {
                log.warn("Streaming the body twice will not work.");
            }
            for (MessageObserver observer : this.observers) {
                observer.bodyRequested(this);
            }
            this.wasStreamed = true;
            this.writeStreamed(out);
            return;
        }
        this.writeAlreadyRead(out);
    }

    protected abstract void writeAlreadyRead(AbstractBodyTransferrer var1) throws IOException;

    protected abstract void writeNotRead(AbstractBodyTransferrer var1) throws IOException;

    protected abstract void writeStreamed(AbstractBodyTransferrer var1) throws IOException;

    public int getLength() throws IOException {
        this.read();
        int length = 0;
        for (Chunk chunk : this.chunks) {
            length += chunk.getLength();
        }
        return length;
    }

    public byte[] getRaw() throws IOException {
        this.read();
        return this.getRawLocal();
    }

    protected abstract byte[] getRawLocal() throws IOException;

    protected boolean hasRelevantObservers() {
        return this.observers.stream().anyMatch(o -> !(o instanceof NonRelevantBodyObserver));
    }

    public String toString() {
        if (this.chunks.isEmpty()) {
            return "";
        }
        try {
            return new String(this.getRaw(), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
            return "Error in body: " + String.valueOf(e);
        }
    }

    public boolean isRead() {
        return this.read;
    }

    void addObserver(MessageObserver observer) {
        if (this.read) {
            observer.bodyComplete(this);
            return;
        }
        if (this.wasStreamed) {
            log.warn("adding body observer after body was streamed.");
        }
        this.observers.add(observer);
    }

    public List<MessageObserver> getObservers() {
        return this.observers;
    }

    public boolean wasStreamed() {
        return this.wasStreamed;
    }

    public Header getTrailer() {
        return null;
    }

    public boolean setTrailer(Header trailer) {
        return false;
    }

    public boolean hasTrailer() {
        return false;
    }
}

