/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.http;

import com.predic8.membrane.core.http.Chunk;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class BodyInputStream
extends InputStream {
    private final List<Chunk> chunks;
    private int currentChunkIndex = 0;
    private int positionWithinChunk = -1;
    private Chunk currentChunk;
    private byte[] currentChunkData;
    private int currentChunkLength;

    public BodyInputStream(List<Chunk> chunks) {
        this.chunks = chunks;
        Chunk chunk = this.currentChunk = chunks.isEmpty() ? null : chunks.getFirst();
        if (this.currentChunk != null) {
            this.currentChunkLength = this.currentChunk.getLength();
            this.currentChunkData = this.currentChunk.getContent();
        } else {
            this.currentChunkIndex = -1;
        }
    }

    private boolean advanceToNextPosition() throws IOException {
        if (this.currentChunk == null) {
            this.currentChunk = this.readNextChunk();
            if (this.currentChunk == null) {
                return false;
            }
            this.chunks.add(this.currentChunk);
            this.currentChunkIndex = this.chunks.size() - 1;
            this.currentChunkLength = this.currentChunk.getLength();
            this.currentChunkData = this.currentChunk.getContent();
        }
        ++this.positionWithinChunk;
        while (this.positionWithinChunk == this.currentChunkLength) {
            ++this.currentChunkIndex;
            if (this.currentChunkIndex == this.chunks.size()) {
                Chunk c = this.readNextChunk();
                if (c == null) {
                    this.currentChunk = null;
                    return false;
                }
                this.chunks.add(c);
            }
            this.currentChunk = this.chunks.get(this.currentChunkIndex);
            this.currentChunkLength = this.currentChunk.getLength();
            this.currentChunkData = this.currentChunk.getContent();
            this.positionWithinChunk = 0;
        }
        return true;
    }

    protected Chunk readNextChunk() throws IOException {
        return null;
    }

    @Override
    public int read() throws IOException {
        if (!this.advanceToNextPosition()) {
            return -1;
        }
        return this.currentChunkData[this.positionWithinChunk] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (!this.advanceToNextPosition()) {
            return -1;
        }
        if (len > this.currentChunkLength - this.positionWithinChunk) {
            len = this.currentChunkLength - this.positionWithinChunk;
        }
        System.arraycopy(this.currentChunkData, this.positionWithinChunk, b, off, len);
        this.positionWithinChunk += len - 1;
        return len;
    }
}

