/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.http;

import com.predic8.membrane.core.Constants;
import com.predic8.membrane.core.http.AbstractBody;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

public class Chunk {
    private final byte[] content;

    public Chunk(byte[] content) {
        this.content = content;
    }

    public byte[] getContent() {
        return this.content;
    }

    public int getLength() {
        if (this.content == null) {
            return 0;
        }
        return this.content.length;
    }

    public void write(OutputStream out) throws IOException {
        if (this.content == null || out == null) {
            return;
        }
        out.write(this.getLengthBytes());
        out.write(Constants.CRLF_BYTES);
        out.write(this.getContent(), 0, this.getLength());
        out.write(Constants.CRLF_BYTES);
        out.flush();
    }

    public String toString() {
        if (this.content == null) {
            return "";
        }
        return new String(this.content, StandardCharsets.UTF_8);
    }

    public int copyChunk(byte[] raw, int destPos) {
        System.arraycopy(this.content, 0, raw, destPos, this.getLength());
        return destPos + this.getLength();
    }

    public int copyChunkLength(byte[] raw, int destPos, AbstractBody body) {
        System.arraycopy(this.getLengthBytes(), 0, raw, destPos, this.getLengthBytes().length);
        return destPos + this.getLengthBytes().length;
    }

    private byte[] getLengthBytes() {
        return Long.toHexString(this.getLength()).getBytes(StandardCharsets.UTF_8);
    }
}

