/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.http;

import com.predic8.membrane.core.Constants;
import com.predic8.membrane.core.http.AbstractBodyTransferrer;
import com.predic8.membrane.core.http.Chunk;
import com.predic8.membrane.core.http.Header;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

public class ChunkedBodyTransferrer
extends AbstractBodyTransferrer {
    OutputStream out;
    protected static final byte[] ZERO = "0".getBytes(StandardCharsets.UTF_8);

    public ChunkedBodyTransferrer(OutputStream out) {
        this.out = out;
    }

    @Override
    public void write(byte[] content, int i, int length) throws IOException {
        ChunkedBodyTransferrer.writeChunkSize(this.out, length);
        this.out.write(content, i, length);
        this.out.write(Constants.CRLF_BYTES);
        this.out.flush();
    }

    @Override
    public void write(Chunk chunk) throws IOException {
        chunk.write(this.out);
    }

    @Override
    public void finish(Header header) throws IOException {
        this.out.write(ZERO);
        this.out.write(Constants.CRLF_BYTES);
        if (header != null) {
            header.write(this.out);
        }
        this.out.write(Constants.CRLF_BYTES);
    }

    protected static void writeChunkSize(OutputStream out, int chunkSize) throws IOException {
        out.write(Integer.toHexString(chunkSize).getBytes(StandardCharsets.UTF_8));
        out.write(Constants.CRLF_BYTES);
    }
}

