/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.http;

import com.predic8.membrane.core.Constants;
import com.predic8.membrane.core.http.AbstractBody;
import com.predic8.membrane.core.http.Body;
import com.predic8.membrane.core.http.BodyCollectingMessageObserver;
import com.predic8.membrane.core.http.ChunkedBody;
import com.predic8.membrane.core.http.ChunkedBodyTransferrer;
import com.predic8.membrane.core.http.EmptyBody;
import com.predic8.membrane.core.http.Header;
import com.predic8.membrane.core.http.MessageObserver;
import com.predic8.membrane.core.http.MimeType;
import com.predic8.membrane.core.http.PlainBodyTransferrer;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.multipart.XOPReconstitutor;
import com.predic8.membrane.core.util.ContentTypeDetector;
import com.predic8.membrane.core.util.EndOfStreamException;
import com.predic8.membrane.core.util.MessageUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Message {
    private static final Logger log = LoggerFactory.getLogger((String)Message.class.getName());
    private static final XOPReconstitutor xopr = new XOPReconstitutor();
    protected Header header = new Header();
    protected AbstractBody body = new EmptyBody();
    protected String version = "1.1";
    private boolean released = false;
    private String errorMessage = "";

    public void read(InputStream in, boolean createBody) throws IOException, EndOfStreamException {
        this.parseStartLine(in);
        this.header = new Header(in);
        if (createBody) {
            this.createBody(in);
        }
    }

    public void readBody() throws IOException {
        this.body.read();
    }

    public void discardBody() {
        try {
            this.body.discard();
        }
        catch (IOException e) {
            log.debug("Error discarding body. Can be ignored.", (Throwable)e);
        }
    }

    public AbstractBody getBody() {
        return this.body;
    }

    public InputStream getBodyAsStream() {
        try {
            return this.body.getContentAsStream();
        }
        catch (IOException e) {
            log.error("Could not get body as stream", (Throwable)e);
            throw new RuntimeException("Could not get body as stream", e);
        }
    }

    public InputStream getBodyAsStreamDecoded() {
        try {
            Message m = xopr.getReconstitutedMessage(this);
            if (m != null) {
                return m.getBodyAsStream();
            }
            return MessageUtil.getContentAsStream(this);
        }
        catch (Exception e) {
            log.error("Could not decode body stream", (Throwable)e);
            throw new RuntimeException("Could not decode body stream", e);
        }
    }

    public String getBodyAsStringDecoded() {
        try {
            return new String(MessageUtil.getContent(this), this.getCharset());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setBody(AbstractBody b) {
        this.discardBody();
        this.body = b;
    }

    public void setBodyContent(byte[] content) {
        this.discardBody();
        this.body = new Body(content);
        this.header.removeFields("Content-Encoding");
        this.header.removeFields("Transfer-Encoding");
        this.header.setContentLength(content.length);
    }

    protected void createBody(InputStream in) throws IOException {
        Request req;
        Message message;
        log.debug("createBody");
        if (this.shouldNotContainBody()) {
            log.debug("empty body created");
            this.body = new EmptyBody();
            return;
        }
        if (this.isHTTP10()) {
            this.body = new Body(in, this.header.getContentLength());
            return;
        }
        if (this.header.isChunked()) {
            this.body = new ChunkedBody(in);
            return;
        }
        if (!this.isKeepAlive() || this.header.hasContentLength() || this.header.isProxyConnectionClose()) {
            this.body = new Body(in, this.header.getContentLength());
            return;
        }
        if (log.isDebugEnabled()) {
            log.error("Message has no content length: {}", (Object)this);
        }
        if ((message = this) instanceof Request && (req = (Request)message).isOPTIONSRequest()) {
            this.body = new EmptyBody();
            return;
        }
        this.body = new Body(in);
    }

    protected abstract void parseStartLine(InputStream var1) throws IOException, EndOfStreamException;

    public Header getHeader() {
        return this.header;
    }

    public synchronized void release() {
        this.notify();
        this.released = true;
    }

    public boolean hasMsgReleased() {
        return this.released;
    }

    public void setHeader(Header srcHeader) {
        this.header = srcHeader;
    }

    public final void write(OutputStream out, boolean retainBody) throws IOException {
        this.writeStartLine(out);
        this.header.write(out);
        out.write(Constants.CRLF_BYTES);
        if (this.header.is100ContinueExpected()) {
            out.flush();
            return;
        }
        this.body.write(this.getHeader().isChunked() ? new ChunkedBodyTransferrer(out) : new PlainBodyTransferrer(out), retainBody);
        out.flush();
    }

    public void writeStartLine(OutputStream out) throws IOException {
        out.write(this.getStartLine().getBytes(StandardCharsets.ISO_8859_1));
    }

    public abstract String getStartLine();

    public boolean isHTTP11() {
        return this.version.equalsIgnoreCase("1.1");
    }

    public boolean isHTTP10() {
        return this.version.equalsIgnoreCase("1.0");
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String toString() {
        return this.getStartLine() + this.header.toString() + "\r\n" + this.body.toString();
    }

    public boolean isKeepAlive() {
        if (this.isHTTP10()) {
            return false;
        }
        if (this.header.getConnection() == null) {
            return true;
        }
        if (this.header.isConnectionClose()) {
            return false;
        }
        return !this.header.isProxyConnectionClose();
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getName() {
        return "message";
    }

    public boolean isBodyEmpty() throws IOException {
        if (this.header.hasContentLength()) {
            return this.header.getContentLength() == 0L;
        }
        if (this.getBody().read) {
            return this.getBody().getLength() == 0;
        }
        return this.getBody() instanceof EmptyBody;
    }

    public abstract boolean shouldNotContainBody();

    public boolean isImage() {
        return MimeType.isImage(this.getHeader().getContentType());
    }

    public boolean isXML() {
        return MimeType.isXML(this.getHeader().getContentType());
    }

    public boolean isJSON() {
        return MimeType.isJson(this.getHeader().getContentType());
    }

    public boolean isHTML() {
        if (this.header.getContentType() == null) {
            return false;
        }
        return ContentTypeDetector.detectEffectiveContentType(this) == ContentTypeDetector.EffectiveContentType.HTML;
    }

    public boolean isGzip() {
        return "gzip".equalsIgnoreCase(this.header.getContentEncoding());
    }

    public boolean isDeflate() {
        return "deflate".equalsIgnoreCase(this.header.getContentEncoding());
    }

    public boolean isBrotli() {
        return "br".equalsIgnoreCase(this.header.getContentEncoding());
    }

    public String getCharset() {
        return this.header.getCharset();
    }

    public void addObserver(MessageObserver observer) {
        this.body.addObserver(observer);
    }

    public int estimateHeapSize() {
        try {
            return 100 + (this.header != null ? this.header.estimateHeapSize() : 0) + (this.body != null ? (this.body.isRead() ? this.body.getLength() : 0) : 0) + (this.errorMessage != null ? 2 * this.errorMessage.length() : 0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public abstract <T extends Message> T createSnapshot(Runnable var1, BodyCollectingMessageObserver.Strategy var2, long var3) throws Exception;

    public <T extends Message> T createMessageSnapshot(T result, Runnable bodyUpdatedCallback, BodyCollectingMessageObserver.Strategy strategy, long limit) {
        result.setHeader(new Header(this.getHeader()));
        result.setErrorMessage(this.getErrorMessage());
        result.setReleased(this.isReleased());
        this.addObserver(new SnapshottingObserver<T>(strategy, limit, result, bodyUpdatedCallback));
        return result;
    }

    public boolean isReleased() {
        return this.released;
    }

    public void setReleased(boolean released) {
        this.released = released;
    }

    public boolean containsObserver(MessageObserver obs) {
        return this.body.observers.contains(obs);
    }

    private static class SnapshottingObserver<T extends Message>
    extends BodyCollectingMessageObserver {
        private final T result;
        private final Runnable bodyUpdatedCallback;

        public SnapshottingObserver(BodyCollectingMessageObserver.Strategy strategy, long limit, T result, Runnable bodyUpdatedCallback) {
            super(strategy, limit);
            this.result = result;
            this.bodyUpdatedCallback = bodyUpdatedCallback;
        }

        @Override
        public void bodyRequested(AbstractBody body) {
        }

        @Override
        public void bodyComplete(AbstractBody body2) {
            try {
                ((Message)this.result).setBody(this.getBody(body2));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            try {
                this.bodyUpdatedCallback.run();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

