/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.http;

import jakarta.mail.internet.ContentType;
import jakarta.mail.internet.ParseException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.MediaType;

public class MimeType {
    public static final String APPLICATION = "application";
    public static final String APPLICATION_SOAP = "application/soap+xml";
    public static final String APPLICATION_XML = "application/xml";
    public static final String TEXT_XML = "text/xml";
    public static final String TEXT_HTML = "text/html";
    public static final String TEXT_XML_UTF8 = "text/xml;charset=UTF-8";
    public static final String TEXT_HTML_UTF8 = "text/html;charset=UTF-8";
    public static final String TEXT_PLAIN = "text/plain";
    public static final String TEXT_PLAIN_UTF8 = "text/plain;charset=UTF-8";
    public static final String APPLICATION_JSON = "application/json";
    public static final String APPLICATION_JSON_UTF8 = "application/json;charset=utf-8";
    public static final String APPLICATION_JOSE_JSON = "application/jose+json";
    public static final String APPLICATION_X_YAML = "application/x-yaml";
    public static final String APPLICATION_PROBLEM_JSON = "application/problem+json";
    public static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    public static final String APPLICATION_APPLY_PATCH_YAML = "application/apply-patch+yaml";
    public static final String APPLICATION_GRAPHQL = "application/graphql";
    public static final String APPLICATION_X_WWW_FORM_URLENCODED = "application/x-www-form-urlencoded";
    public static final String APPLICATION_X_JAVASCRIPT = "application/x-javascript";
    public static final String TEXT_JAVASCRIPT = "text/javascript";
    public static final String TEXT_X_JAVASCRIPT = "text/x-javascript";
    public static final String TEXT_X_JSON = "text/x-json";
    public static final ContentType APPLICATION_JSON_CONTENT_TYPE = new ContentType("application", "json", null);
    public static final ContentType APPLICATION_X_WWW_FORM_URLENCODED_CONTENT_TYPE = new ContentType("application", "application/x-www-form-urlencoded", null);

    public static boolean isXML(String mediaType) {
        try {
            return MimeType.isXML(new jakarta.activation.MimeType(mediaType));
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isXML(jakarta.activation.MimeType mediaType) {
        if (mediaType == null) {
            return false;
        }
        if (mediaType.getSubType().contains("xml")) {
            return true;
        }
        if (mediaType.getSubType().contains("xhtml")) {
            return true;
        }
        return mediaType.getSubType().contains("svg");
    }

    public static boolean isText(String mediaType) {
        try {
            return MimeType.isText(new jakarta.activation.MimeType(mediaType));
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isText(jakarta.activation.MimeType mediaType) {
        if (mediaType == null) {
            return false;
        }
        if (mediaType.getPrimaryType().equals("text")) {
            return true;
        }
        String st = mediaType.getSubType();
        return st.contains("text");
    }

    public static boolean isJson(String mediaType) {
        try {
            return MimeType.isJson(new jakarta.activation.MimeType(mediaType));
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isJson(jakarta.activation.MimeType type) {
        if (type == null) {
            return false;
        }
        return StringUtils.containsIgnoreCase((CharSequence)type.getSubType(), (CharSequence)"json");
    }

    public static boolean isImage(String mediaType) {
        try {
            return MimeType.isImage(new jakarta.activation.MimeType(mediaType));
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isImage(jakarta.activation.MimeType mediaType) {
        if (mediaType == null) {
            return false;
        }
        return mediaType.getPrimaryType().equals("image");
    }

    public static boolean isHtml(String mediaType) {
        try {
            return MimeType.isHtml(new jakarta.activation.MimeType(mediaType));
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isHtml(jakarta.activation.MimeType mediaType) {
        if (mediaType == null) {
            return false;
        }
        return mediaType.getSubType().contains("html");
    }

    public static boolean isBinary(String mediaType) {
        try {
            return MimeType.isBinary(new jakarta.activation.MimeType(mediaType));
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isBinary(jakarta.activation.MimeType mediaType) {
        if (mediaType == null) {
            return false;
        }
        switch (mediaType.getPrimaryType()) {
            case "image": 
            case "video": 
            case "audio": {
                return true;
            }
        }
        String st = mediaType.getSubType();
        return st.contains("octet-stream") || st.contains("zip");
    }

    public static boolean isWWWFormUrlEncoded(String mediaType) {
        return MimeType.isOfMediaType(APPLICATION_X_WWW_FORM_URLENCODED, mediaType);
    }

    public static boolean isOfMediaType(String expectedType, String actualType) {
        try {
            return new ContentType(actualType).match(expectedType);
        }
        catch (ParseException parseException) {
            return false;
        }
    }

    public static List<MediaType> sortMimeTypeByQualityFactorAscending(String s) {
        List m = MediaType.parseMediaTypes((String)s);
        m.sort(Comparator.comparingDouble(MediaType::getQualityValue));
        Collections.reverse(m);
        return m;
    }
}

