/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.AbstractBody;
import com.predic8.membrane.core.http.AbstractMessageObserver;
import com.predic8.membrane.core.http.Body;
import com.predic8.membrane.core.http.BodyCollectingMessageObserver;
import com.predic8.membrane.core.http.EmptyBody;
import com.predic8.membrane.core.http.Header;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.http.NonRelevantBodyObserver;
import com.predic8.membrane.core.transport.http.EOFWhileReadingFirstLineException;
import com.predic8.membrane.core.transport.http.EOFWhileReadingLineException;
import com.predic8.membrane.core.transport.http.NoResponseException;
import com.predic8.membrane.core.util.EndOfStreamException;
import com.predic8.membrane.core.util.HttpUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Response
extends Message {
    private static final Logger log = LoggerFactory.getLogger((String)Response.class.getName());
    private static final ObjectMapper om = new ObjectMapper();
    private static final Pattern pattern = Pattern.compile("HTTP/(\\d\\.\\d) (\\d\\d\\d)( (.*?))?$");
    private int statusCode;
    private String statusMessage;
    private static final String SERVER_HEADER = "Membrane API Gateway";

    public static ResponseBuilder ok(String msg) {
        return Response.ok().contentType("text/html;charset=UTF-8").body(msg);
    }

    public static ResponseBuilder statusCode(int statusCode) {
        return ResponseBuilder.newInstance().status(statusCode);
    }

    public static ResponseBuilder ok() {
        return ResponseBuilder.newInstance().status(200).header("Server", SERVER_HEADER).bodyEmpty();
    }

    public static ResponseBuilder accepted() {
        return ResponseBuilder.newInstance().status(202).header("Server", SERVER_HEADER).bodyEmpty();
    }

    public static ResponseBuilder noContent() {
        return ResponseBuilder.newInstance().status(204);
    }

    public static ResponseBuilder found(String location) {
        return ResponseBuilder.newInstance().status(302, "Found").header("Location", location).bodyEmpty();
    }

    public static ResponseBuilder notModified(String date) {
        return ResponseBuilder.newInstance().status(304).header("Server", SERVER_HEADER).header("Date", date).bodyEmpty();
    }

    public static ResponseBuilder badRequest() {
        return ResponseBuilder.newInstance().status(400).header("Server", SERVER_HEADER).bodyEmpty();
    }

    public static ResponseBuilder badRequest(String message) {
        return Response.fromStatusCode(400, message).header("Server", SERVER_HEADER);
    }

    public static ResponseBuilder badRequest(String message, boolean escape) {
        return ResponseBuilder.newInstance().status(400).header("Server", SERVER_HEADER).contentType("text/html;charset=UTF-8").body(escape ? HttpUtil.htmlMessage("Bad Request", message) : HttpUtil.unescapedHtmlMessage("Bad Request", message));
    }

    public static ResponseBuilder continue100() {
        return ResponseBuilder.newInstance().status(100);
    }

    public static ResponseBuilder redirect(String uri, boolean permanent) {
        String escaped = StringEscapeUtils.escapeXml11((String)uri);
        return ResponseBuilder.newInstance().status(permanent ? 301 : 307, permanent ? "Moved Permanently" : "Temporary Redirect").header("Location", uri).contentType("text/html;charset=UTF-8").body(HttpUtil.unescapedHtmlMessage("Moved.", "This page has moved to <a href=\"" + escaped + "\">" + escaped + "</a>."));
    }

    public static ResponseBuilder redirectWithout300(String uri) {
        String escaped = StringEscapeUtils.escapeXml11((String)uri);
        return Response.redirectWithout300(uri, "This page has moved to <a href=\"%s\">%s</a>\n".formatted(escaped, escaped));
    }

    public static ResponseBuilder redirectWithout300(String uri, String body) {
        return ResponseBuilder.newInstance().status(200).contentType("text/html;charset=UTF-8").location(uri).body("\t<html>\n\t  <head><meta http-equiv=\"refresh\" content=\"0;URL='%s'\"/></head>\n\t  <body>%s</body>\n\t</html>\n".formatted(StringEscapeUtils.escapeXml11((String)uri), body));
    }

    public static ResponseBuilder serviceUnavailable(String message) {
        return Response.fromStatusCode(503, message);
    }

    public static ResponseBuilder internalServerError() {
        return Response.fromStatusCode(500, "");
    }

    public static ResponseBuilder notImplemented() {
        return Response.fromStatusCode(501, "");
    }

    public static ResponseBuilder internalServerError(String message) {
        return Response.fromStatusCode(500, message);
    }

    public static ResponseBuilder badGateway(String message) {
        return Response.fromStatusCode(502, message);
    }

    public static ResponseBuilder gatewayTimeout(String message) {
        return Response.fromStatusCode(504, message);
    }

    public static ResponseBuilder forbidden() {
        return Response.fromStatusCode(403, "");
    }

    public static ResponseBuilder notFound() {
        return Response.fromStatusCode(404, "");
    }

    public static ResponseBuilder forbidden(String message) {
        return Response.fromStatusCode(403, message);
    }

    public static ResponseBuilder unauthorized(String message) {
        return Response.fromStatusCode(401, message);
    }

    public static ResponseBuilder fromStatusCode(int statusCode, String msg) {
        return ResponseBuilder.newInstance().status(statusCode).contentType("text/html;charset=UTF-8").body(HttpUtil.unescapedHtmlMessage("%d %s.".formatted(statusCode, HttpUtil.getMessageForStatusCode(statusCode)), msg));
    }

    public static ResponseBuilder unauthorized() {
        return ResponseBuilder.newInstance().status(401).contentType("text/html;charset=UTF-8").bodyEmpty();
    }

    public static ResponseBuilder methodNotAllowed() {
        return ResponseBuilder.newInstance().status(405).contentType("text/html;charset=UTF-8").contentType("text/html;charset=UTF-8").body(HttpUtil.htmlMessage("405 Method Not Allowed", ""));
    }

    @Override
    public String getStartLine() {
        return "HTTP/" + this.version + " " + this.statusCode + " " + this.statusMessage + "\r\n";
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    @Override
    public void parseStartLine(InputStream in) throws IOException {
        String line;
        try {
            line = HttpUtil.readLine(in);
        }
        catch (EOFWhileReadingLineException e) {
            if (e.getLineSoFar().isEmpty()) {
                throw new NoResponseException(e);
            }
            throw new EOFWhileReadingFirstLineException(e.getLineSoFar());
        }
        Matcher matcher = pattern.matcher(line);
        if (!matcher.find()) {
            throw new RuntimeException("Invalid server response: " + line);
        }
        this.version = matcher.group(1);
        this.statusCode = Integer.parseInt(matcher.group(2));
        this.statusMessage = matcher.group(4);
    }

    @Override
    public void read(InputStream in, boolean createBody) throws IOException, EndOfStreamException {
        this.parseStartLine(in);
        if (this.getStatusCode() == 100) {
            HttpUtil.readLine(in);
            return;
        }
        this.header = new Header(in);
        if (createBody) {
            this.createBody(in);
        }
    }

    @Override
    protected void createBody(InputStream in) throws IOException {
        if (this.isRedirect() && this.mayHaveNoBody()) {
            return;
        }
        super.createBody(in);
    }

    public boolean isRedirect() {
        return this.statusCode >= 300 && this.statusCode < 400;
    }

    public boolean hasNoContent() {
        return this.statusCode == 204;
    }

    @Override
    public String getName() {
        return " " + this.statusCode;
    }

    @Override
    public boolean shouldNotContainBody() {
        return this.statusCode == 100 || this.statusCode == 101 || this.statusCode == 204 || this.statusCode == 205;
    }

    public boolean isOk() {
        return this.statusCode >= 200 && this.statusCode < 300;
    }

    public boolean isUserError() {
        return this.statusCode >= 400 && this.statusCode < 500;
    }

    public boolean isServerError() {
        return this.statusCode >= 500;
    }

    private boolean mayHaveNoBody() {
        if (this.header.isChunked()) {
            return false;
        }
        if (this.header.hasContentLength()) {
            return false;
        }
        return this.header.getContentType() == null;
    }

    @Override
    public boolean isKeepAlive() {
        if (this.isRedirect() && this.mayHaveNoBody()) {
            return false;
        }
        return super.isKeepAlive();
    }

    @Override
    public int estimateHeapSize() {
        return super.estimateHeapSize() + 12 + (this.statusMessage != null ? 2 * this.statusMessage.length() : 0);
    }

    @Override
    public <T extends Message> T createSnapshot(Runnable bodyUpdatedCallback, BodyCollectingMessageObserver.Strategy strategy, long limit) {
        Response result = this.createMessageSnapshot(new Response(), bodyUpdatedCallback, strategy, limit);
        result.setStatusCode(this.getStatusCode());
        result.setStatusMessage(this.getStatusMessage());
        return (T)result;
    }

    public static class ResponseBuilder {
        private final Response res = new Response();

        public Response build() {
            return this.res;
        }

        public Exchange buildExchange() {
            Exchange exc = new Exchange(null);
            Response res = this.build();
            exc.setResponse(res);
            return exc;
        }

        public ResponseBuilder status(int code) {
            this.res.setStatusCode(code);
            this.res.setStatusMessage(HttpUtil.getMessageForStatusCode(code));
            return this;
        }

        public ResponseBuilder status(int code, String msg) {
            this.res.setStatusCode(code);
            this.res.setStatusMessage(msg);
            return this;
        }

        public ResponseBuilder body(String msg) {
            this.res.setBodyContent(msg.getBytes(StandardCharsets.UTF_8));
            return this;
        }

        public ResponseBuilder body(Map<String, Object> map) throws JsonProcessingException {
            this.res.setBodyContent(om.writeValueAsBytes(map));
            this.res.getHeader().setContentType("application/json");
            return this;
        }

        public ResponseBuilder body(byte[] body) {
            this.res.setBodyContent(body);
            return this;
        }

        public ResponseBuilder json(String json) {
            this.res.setBodyContent(json.getBytes(StandardCharsets.UTF_8));
            this.res.header.setContentType("application/json");
            return this;
        }

        public ResponseBuilder body(InputStream stream, boolean closeStreamWhenDone) {
            this.res.getHeader().removeFields("Content-Length");
            this.res.getHeader().setValue("Transfer-Encoding", "chunked");
            Body b = new Body(stream);
            if (closeStreamWhenDone) {
                b.addObserver(new BodyCompleteMessageObserver(stream));
            }
            this.res.setBody(b);
            return this;
        }

        public ResponseBuilder bodyEmpty() {
            this.res.getHeader().setContentLength(0L);
            this.res.body = new EmptyBody();
            return this;
        }

        public ResponseBuilder header(Header header) {
            this.res.setHeader(header);
            return this;
        }

        public ResponseBuilder header(String k, String v) {
            this.res.getHeader().add(k, v);
            return this;
        }

        public ResponseBuilder contentType(String type) {
            this.res.getHeader().setContentType(type);
            return this;
        }

        public ResponseBuilder yaml() {
            this.res.getHeader().setContentType("application/x-yaml");
            return this;
        }

        public ResponseBuilder location(String location) {
            this.res.getHeader().setLocation(location);
            return this;
        }

        public static ResponseBuilder newInstance() {
            return new ResponseBuilder();
        }

        public ResponseBuilder dontCache() {
            this.res.getHeader().setNoCacheResponseHeaders();
            return this;
        }

        private static class BodyCompleteMessageObserver
        extends AbstractMessageObserver
        implements NonRelevantBodyObserver {
            private final InputStream stream;

            public BodyCompleteMessageObserver(InputStream stream) {
                this.stream = stream;
            }

            @Override
            public void bodyComplete(AbstractBody body) {
                try {
                    this.stream.close();
                }
                catch (IOException e) {
                    log.error("Could not close body stream.", (Throwable)e);
                }
            }
        }
    }
}

