/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.http.xml;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.predic8.membrane.core.config.AbstractXmlElement;
import com.predic8.membrane.core.http.Message;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

class JSONBody
extends AbstractXmlElement {
    private final Message msg;

    public JSONBody(Message msg) {
        this.msg = msg;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void write(XMLStreamWriter out) throws XMLStreamException {
        out.writeAttribute("type", "json");
        try {
            JsonFactory jsonFactory = new JsonFactory();
            JsonParser jp = jsonFactory.createParser((Reader)new InputStreamReader(this.msg.getBodyAsStreamDecoded(), this.msg.getCharset()));
            ArrayList<String> stack = new ArrayList<String>();
            String name = "root";
            while (jp.nextToken() != null) {
                switch (jp.getCurrentToken()) {
                    case START_OBJECT: {
                        if (name == null) break;
                        stack.add(name);
                        out.writeStartElement(name);
                        out.writeAttribute("type", "o");
                        name = null;
                        break;
                    }
                    case END_OBJECT: {
                        out.writeEndElement();
                        name = (String)stack.remove(stack.size() - 1);
                        if (!stack.isEmpty()) break;
                        return;
                    }
                    case FIELD_NAME: {
                        name = jp.getCurrentName();
                        break;
                    }
                    case START_ARRAY: {
                        if (name != null) {
                            stack.add(name);
                            out.writeStartElement(name);
                            out.writeAttribute("type", "a");
                        }
                        name = "item";
                        break;
                    }
                    case END_ARRAY: {
                        out.writeEndElement();
                        name = (String)stack.remove(stack.size() - 1);
                        if (!stack.isEmpty()) break;
                        return;
                    }
                    case VALUE_TRUE: 
                    case VALUE_FALSE: {
                        out.writeStartElement(name);
                        out.writeAttribute("type", "b");
                        out.writeCharacters(Boolean.toString(jp.getBooleanValue()));
                        out.writeEndElement();
                        break;
                    }
                    case VALUE_NULL: {
                        out.writeStartElement(name);
                        out.writeAttribute("type", "n");
                        out.writeAttribute("isNull", "true");
                        out.writeEndElement();
                        break;
                    }
                    case VALUE_STRING: 
                    case VALUE_NUMBER_INT: 
                    case VALUE_NUMBER_FLOAT: {
                        out.writeStartElement(name);
                        out.writeAttribute("type", jp.getCurrentToken() == JsonToken.VALUE_STRING ? "s" : (jp.getCurrentToken() == JsonToken.VALUE_NUMBER_INT ? "i" : "f"));
                        out.writeCharacters(jp.getText());
                        out.writeEndElement();
                        break;
                    }
                    case VALUE_EMBEDDED_OBJECT: 
                    case NOT_AVAILABLE: {
                        throw new RuntimeException(jp.getCurrentToken().toString());
                    }
                }
            }
            return;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

