/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.http.xml;

import com.predic8.membrane.core.http.xml.Headers;
import com.predic8.membrane.core.http.xml.Message;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;

public class Response
extends Message {
    public static final String ELEMENT_NAME = "response";
    private int statusCode;
    private String statusMessage;

    public Response(com.predic8.membrane.core.http.Response res) throws Exception {
        super(res);
        this.setStatusCode(res.getStatusCode());
        this.setStatusMessage(res.getStatusMessage());
    }

    public Response() {
    }

    @Override
    protected void parseAttributes(XMLStreamReader token) throws XMLStreamException {
    }

    @Override
    protected void parseChildren(XMLStreamReader token, String child) throws Exception {
        if ("headers".equals(child)) {
            this.headers = (Headers)new Headers().parse(token);
        } else if ("status".equals(child)) {
            this.statusCode = Integer.parseInt((String)StringUtils.defaultIfBlank((CharSequence)token.getAttributeValue("", "status-code"), (CharSequence)"0"));
            this.statusMessage = "";
            while (token.hasNext()) {
                token.next();
                if (token.isStartElement()) {
                    this.parseChildren(token, token.getName().getLocalPart());
                    continue;
                }
                if (token.isCharacters()) {
                    this.statusMessage = this.statusMessage + token.getText();
                    continue;
                }
                if (!token.isEndElement()) continue;
                break;
            }
        }
    }

    @Override
    public void write(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement("http", ELEMENT_NAME, "http://membrane-soa.org/schemas/http/v1/");
        out.writeNamespace("http", "http://membrane-soa.org/schemas/http/v1/");
        out.writeStartElement("status");
        out.writeAttribute("code", "" + this.statusCode);
        out.writeCharacters(this.statusMessage);
        out.writeEndElement();
        this.writeIfNotNull(this.headers, out);
        if (this.body != null) {
            out.writeStartElement("body");
            this.body.write(out);
            out.writeEndElement();
        }
        out.writeEndElement();
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    @Override
    protected String getElementName() {
        return ELEMENT_NAME;
    }
}

