/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor;

import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.interceptor.FlowController;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.flow.AbstractFlowInterceptor;
import com.predic8.membrane.core.proxies.Proxy;
import java.util.EnumSet;

public class AbstractInterceptor
implements Interceptor {
    protected String name = this.getClass().getName();
    private EnumSet<Interceptor.Flow> flow = Interceptor.Flow.Set.REQUEST_RESPONSE_ABORT_FLOW;
    protected Router router;

    @Override
    public Outcome handleRequest(Exchange exc) {
        return Outcome.CONTINUE;
    }

    @Override
    public Outcome handleResponse(Exchange exc) {
        return Outcome.CONTINUE;
    }

    @Override
    public void handleAbort(Exchange exchange) {
    }

    @Override
    public String getDisplayName() {
        return this.name;
    }

    @Override
    public void setDisplayName(String name) {
        this.name = name;
    }

    @Override
    public void setFlow(EnumSet<Interceptor.Flow> flow) {
        this.flow = flow;
    }

    @Override
    public EnumSet<Interceptor.Flow> getFlow() {
        return this.flow;
    }

    @Override
    public boolean handlesRequests() {
        return this.flow.contains((Object)Interceptor.Flow.REQUEST);
    }

    @Override
    public boolean handlesResponses() {
        return this.flow.contains((Object)Interceptor.Flow.RESPONSE);
    }

    @Override
    public String getShortDescription() {
        return "";
    }

    @Override
    public String getLongDescription() {
        return this.getShortDescription();
    }

    @Override
    public final String getHelpId() {
        MCElement annotation = this.getClass().getAnnotation(MCElement.class);
        if (annotation == null) {
            return null;
        }
        if (!annotation.id().isEmpty()) {
            return annotation.id();
        }
        return annotation.name();
    }

    public void init() {
    }

    @Override
    public final void init(Router router) {
        this.router = router;
        this.init();
    }

    public <T extends Proxy> T getProxy() {
        return (T)this.getRouter().getRuleManager().getRules().stream().filter(proxy -> proxy.getInterceptors() != null).filter(proxy -> proxy.getInterceptors().stream().anyMatch(this::hasSameReferenceAs)).findAny().get();
    }

    private boolean hasSameReferenceAs(Interceptor i) {
        if (i instanceof AbstractFlowInterceptor) {
            return ((AbstractFlowInterceptor)i).getInterceptors().stream().anyMatch(this::hasSameReferenceAs);
        }
        return i == this;
    }

    @Override
    public Router getRouter() {
        return this.router;
    }

    public FlowController getFlowController() {
        return this.router.getFlowController();
    }

    public static Message getMessage(Exchange exc, Interceptor.Flow flow) {
        return switch (flow) {
            default -> throw new MatchException(null, null);
            case Interceptor.Flow.REQUEST -> exc.getRequest();
            case Interceptor.Flow.RESPONSE, Interceptor.Flow.ABORT -> exc.getResponse();
        };
    }

    public String toString() {
        return this.getDisplayName();
    }
}

