/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor;

import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.core.exceptions.ProblemDetails;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.session.JwtSessionManager;
import com.predic8.membrane.core.interceptor.session.SessionManager;
import com.predic8.membrane.core.util.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInterceptorWithSession
extends AbstractInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AbstractInterceptorWithSession.class);
    SessionManager sessionManager;

    @Override
    public void init() {
        super.init();
        if (this.sessionManager == null) {
            this.sessionManager = new JwtSessionManager();
        }
        try {
            this.sessionManager.init(this.router);
        }
        catch (Exception e) {
            throw new ConfigurationException("Could not init session manager.", e);
        }
    }

    protected abstract Outcome handleRequestInternal(Exchange var1) throws Exception;

    protected abstract Outcome handleResponseInternal(Exchange var1) throws Exception;

    @Override
    public Outcome handleRequest(Exchange exc) {
        Outcome outcome;
        try {
            outcome = this.handleRequestInternal(exc);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            ProblemDetails.internal(this.router.isProduction(), this.getDisplayName()).flow(Interceptor.Flow.REQUEST).detail("Error handling request!").exception(e).buildAndSetResponse(exc);
            return Outcome.ABORT;
        }
        this.sessionManager.postProcess(exc);
        return outcome;
    }

    @Override
    public Outcome handleResponse(Exchange exc) {
        try {
            Outcome outcome = this.handleResponseInternal(exc);
            this.sessionManager.postProcess(exc);
            return outcome;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            ProblemDetails.internal(this.router.isProduction(), this.getDisplayName()).flow(Interceptor.Flow.RESPONSE).detail("Error handling response!").exception(e).buildAndSetResponse(exc);
            return Outcome.ABORT;
        }
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    @MCChildElement
    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }
}

