/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor;

import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exceptions.ProblemDetails;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.proxies.Proxy;
import com.predic8.membrane.core.proxies.SSLableProxy;
import com.predic8.membrane.core.transport.ssl.AcmeSSLContext;
import com.predic8.membrane.core.transport.ssl.SSLContext;
import com.predic8.membrane.core.transport.ssl.acme.AcmeClient;
import java.util.Arrays;
import org.jose4j.lang.JoseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="acmeHttpChallenge")
public class AcmeHttpChallengeInterceptor
extends AbstractInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(AcmeHttpChallengeInterceptor.class);
    public static final String PREFIX = "/.well-known/acme-challenge/";
    private boolean ignorePort;

    public AcmeHttpChallengeInterceptor() {
        this.name = "acme http challenge";
    }

    @Override
    public Outcome handleRequest(Exchange exc) {
        if (exc.getRequest().getUri().startsWith(PREFIX)) {
            String token = exc.getRequest().getUri().substring(PREFIX.length());
            String host = this.ignorePort ? exc.getRequest().getHeader().getHost().replaceAll(":.*", "") : exc.getRequest().getHeader().getHost();
            for (Proxy proxy : this.router.getRules()) {
                String keyAuth;
                AcmeClient acmeClient;
                String correctToken;
                AcmeSSLContext acmeSSLContext;
                SSLableProxy sp;
                SSLContext sslInboundContext;
                if (!(proxy instanceof SSLableProxy) || !((sslInboundContext = (sp = (SSLableProxy)proxy).getSslInboundContext()) instanceof AcmeSSLContext) || Arrays.stream((acmeSSLContext = (AcmeSSLContext)sslInboundContext).getHosts()).noneMatch(h -> h.equals(host)) || (correctToken = (acmeClient = acmeSSLContext.getClient()).getToken(host)) == null || !correctToken.equals(token)) continue;
                try {
                    keyAuth = token + "." + acmeClient.getThumbprint();
                }
                catch (JoseException e) {
                    ProblemDetails.user(this.router.isProduction(), this.getDisplayName()).detail("Could not create thumbprint!").exception(e).buildAndSetResponse(exc);
                    return Outcome.ABORT;
                }
                exc.setResponse(Response.ok().header("Content-Type", "application/octet-stream").body(keyAuth).build());
                return Outcome.RETURN;
            }
            LOG.warn("Returning 404 in response to ACME challenge token {}", (Object)token);
            exc.setResponse(Response.notFound().build());
            return Outcome.RETURN;
        }
        return super.handleRequest(exc);
    }

    public boolean isIgnorePort() {
        return this.ignorePort;
    }

    public void setIgnorePort(boolean ignorePort) {
        this.ignorePort = ignorePort;
    }

    @Override
    public String getShortDescription() {
        return "Responds to HTTP requests starting with <font style=\"font-family: monospace\">/.well-known/acme-challenge/</font>.";
    }

    @Override
    public String getLongDescription() {
        return "<div>Responds to HTTP requests starting with <font style=\"font-family: monospace\">/.well-known/acme-challenge/</font>.<br/>See ACME (RFC 8555, also known as \"Let's Encrypt\") <a href=\"https://www.rfc-editor.org/rfc/rfc8555.html#section-8.3\">HTTP Challenges</a> for details.</div>";
    }
}

