/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.config.Path;
import com.predic8.membrane.core.exceptions.ProblemDetails;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.openapi.serviceproxy.APIProxy;
import com.predic8.membrane.core.openapi.serviceproxy.APIProxyKey;
import com.predic8.membrane.core.openapi.serviceproxy.OpenAPIRecord;
import com.predic8.membrane.core.proxies.Proxy;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="APIsJSON")
public class ApisJsonInterceptor
extends AbstractInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ApisJsonInterceptor.class);
    private static final ObjectMapper om = new ObjectMapper();
    private static final String YYYY_MM_DD = "yyyy-MM-dd";
    private static final String SPECIFICATION_VERSION = "0.18";
    private byte[] apisJson;
    private String rootDomain = "membrane";
    private String collectionId = "apis";
    private String collectionName = "APIs";
    private String description = "APIs.json Document";
    private String apisJsonUrl;
    private Date created = new Date();
    private Date modified = new Date();

    @Override
    public Outcome handleRequest(Exchange exc) {
        if (this.apisJson == null) {
            try {
                this.initJson(this.router, exc);
            }
            catch (JsonProcessingException e) {
                ProblemDetails.internal(this.router.isProduction(), this.getDisplayName()).detail("Could not create APIs JSON!").exception(e).buildAndSetResponse(exc);
                return Outcome.ABORT;
            }
        }
        exc.setResponse(new Response.ResponseBuilder().body(this.apisJson).contentType("application/json").build());
        return Outcome.RETURN;
    }

    public void initJson(Router router, Exchange exc) throws JsonProcessingException {
        if (this.apisJson != null) {
            return;
        }
        if (this.apisJsonUrl == null) {
            this.apisJsonUrl = ApisJsonInterceptor.getProtocol(exc.getProxy()) + exc.getRequest().getHeader().getHost() + exc.getRequest().getUri();
        }
        ObjectNode apis = om.createObjectNode();
        apis.put("aid", this.rootDomain + ":" + this.collectionId);
        apis.put("name", this.collectionName);
        apis.put("description", this.description);
        apis.put("url", this.apisJsonUrl);
        apis.put("created", new SimpleDateFormat(YYYY_MM_DD).format(this.created));
        apis.put("modified", new SimpleDateFormat(YYYY_MM_DD).format(this.modified));
        apis.put("specificationVersion", SPECIFICATION_VERSION);
        apis.putArray("apis").addAll(router.getRuleManager().getRules().stream().filter(APIProxy.class::isInstance).mapMulti((rule, sink) -> {
            APIProxy r = (APIProxy)rule;
            if (r.getApiRecords().isEmpty()) {
                sink.accept(this.jsonNodeFromApiProxy(r, null, null));
            } else {
                r.getApiRecords().forEach((id, rec) -> sink.accept(this.jsonNodeFromApiProxy(r, (String)id, (OpenAPIRecord)rec)));
            }
        }).toList());
        this.apisJson = om.writeValueAsBytes((Object)apis);
    }

    JsonNode jsonNodeFromApiProxy(APIProxy api, String recordId, OpenAPIRecord apiRecord) {
        ObjectNode apiJson = om.createObjectNode();
        apiJson.put("aid", this.customIdOrBuildDefault(api, recordId));
        apiJson.put("name", apiRecord != null ? apiRecord.getApi().getInfo().getTitle() : api.getName());
        apiJson.put("description", apiRecord != null && api.getDescription() == null && apiRecord.getApi().getInfo().getDescription() != null ? apiRecord.getApi().getInfo().getDescription() : Optional.ofNullable(api.getDescription()).map(APIProxy.ApiDescription::getContent).orElse("API"));
        apiJson.put("humanUrl", ApisJsonInterceptor.getProtocol(api) + ApisJsonInterceptor.getHost(api) + (String)(apiRecord != null ? "/api-docs/ui/" + recordId : "/api-docs"));
        apiJson.put("baseUrl", ApisJsonInterceptor.getProtocol(api) + ApisJsonInterceptor.getHost(api) + Optional.ofNullable(api.getPath()).map(Path::getValue).orElse("/"));
        if (apiRecord != null) {
            apiJson.put("version", apiRecord.getApi().getInfo().getVersion());
        }
        return apiJson;
    }

    private static String getHost(APIProxy api) {
        String hostname = Objects.equals(api.getKey().getHost(), "*") ? "localhost" : api.getKey().getHost();
        return hostname + (String)(api.getPort() == 80 || api.getPort() == 443 ? "" : ":" + api.getPort());
    }

    private String customIdOrBuildDefault(APIProxy api, String recordId) {
        if (api.getId() != null) {
            return api.getId();
        }
        return recordId != null ? this.rootDomain + ":" + recordId : this.buildDefaultAPIProxyId(api);
    }

    private String buildDefaultAPIProxyId(APIProxy api) {
        return this.rootDomain + ":" + ((APIProxyKey)api.getKey()).getKeyId();
    }

    @NotNull
    private static String getProtocol(Proxy proxy) {
        return proxy.getProtocol() + "://";
    }

    @MCAttribute
    public void setRootDomain(String rootDomain) {
        this.rootDomain = rootDomain;
    }

    @MCAttribute
    public void setCollectionId(String collectionId) {
        this.collectionId = collectionId;
    }

    @MCAttribute(attributeName="name")
    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    @MCAttribute
    public void setDescription(String description) {
        this.description = description;
    }

    @MCAttribute(attributeName="url")
    public void setApisJsonUrl(String apisJsonUrl) {
        this.apisJsonUrl = apisJsonUrl;
    }

    @MCAttribute
    public void setCreated(String created) throws ParseException {
        this.created = new SimpleDateFormat(YYYY_MM_DD).parse(created);
    }

    @MCAttribute
    public void setModified(String modified) throws ParseException {
        this.modified = new SimpleDateFormat(YYYY_MM_DD).parse(modified);
    }

    @Override
    public String getDisplayName() {
        return "APIs Json";
    }

    @Override
    public String getShortDescription() {
        return "Displays all deployed API Proxies in APIs.json format";
    }

    @Override
    public String getLongDescription() {
        return "WIP";
    }
}

