/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor;

import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.AbstractExchange;
import com.predic8.membrane.core.http.Body;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import java.io.InputStream;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@MCElement(name="authHead2Body")
public class AuthHead2BodyInterceptor
extends AbstractInterceptor {
    static final String COM_NS = "test";
    static final String NOR_NS = "http://cooreo.com.br/normandes-EnviaSMS";
    static final String XSI_NS = "http://www.w3.org/2001/XMLSchema-instance";

    public Outcome handleRequest(AbstractExchange exchange) throws Exception {
        Document doc = this.getDocument(exchange.getRequest().getBodyAsStreamDecoded(), exchange.getRequest().getCharset());
        Element header = this.getAuthorisationHeader(doc);
        if (header == null) {
            return Outcome.CONTINUE;
        }
        Element nor = this.getNorElement(doc);
        nor.appendChild(this.getUsername(doc, header));
        nor.appendChild(this.getPassword(doc, header));
        header.getParentNode().removeChild(header);
        exchange.getRequest().setBody(new Body(this.DOM2String(doc).getBytes(exchange.getRequest().getCharset())));
        return Outcome.CONTINUE;
    }

    private Node getPassword(Document doc, Element header) {
        Element e = doc.createElement("password");
        e.appendChild(doc.createTextNode(doc.getElementsByTagNameNS(COM_NS, "password").item(0).getTextContent()));
        e.setAttributeNS(XSI_NS, "xsi:type", "xsd:string");
        return e;
    }

    private Node getUsername(Document doc, Element header) {
        Element e = doc.createElement("username");
        e.appendChild(doc.createTextNode(doc.getElementsByTagNameNS(COM_NS, "userName").item(0).getTextContent()));
        e.setAttributeNS(XSI_NS, "xsi:type", "xsd:string");
        return e;
    }

    private Element getNorElement(Document doc) {
        return (Element)doc.getElementsByTagNameNS(NOR_NS, "request").item(0);
    }

    private Element getAuthorisationHeader(Document doc) {
        NodeList nl = doc.getElementsByTagNameNS(COM_NS, "authorization");
        if (nl.getLength() == 0) {
            return null;
        }
        return (Element)nl.item(0);
    }

    private Document getDocument(InputStream xmlDocument, String encoding) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        InputSource is = new InputSource(xmlDocument);
        is.setEncoding(encoding);
        return dbf.newDocumentBuilder().parse(is);
    }

    private String DOM2String(Document doc) throws Exception {
        Transformer xformer = TransformerFactory.newInstance().newTransformer();
        StringWriter writer = new StringWriter();
        xformer.transform(new DOMSource(doc), new StreamResult(writer));
        return writer.toString();
    }
}

