/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor;

import com.googlecode.jatl.Html;
import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.annot.Required;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="counter")
public class CountInterceptor
extends AbstractInterceptor {
    private static final Logger log = LoggerFactory.getLogger((String)CountInterceptor.class.getName());
    private int counter;

    public CountInterceptor() {
        this.name = "count interceptor";
    }

    @Override
    public Outcome handleRequest(Exchange exc) {
        log.debug("{} request received.", (Object)(++this.counter));
        exc.setResponse(Response.ok().header("Content-Type", "text/html;charset=UTF-8").body(this.getPage()).build());
        return Outcome.RETURN;
    }

    private String getPage() {
        StringWriter writer = new StringWriter();
        new Html(writer){
            {
                this.html();
                this.head();
                ((Html)((Html)this.title()).text(CountInterceptor.this.name)).end();
                this.end();
                this.body();
                try {
                    ((Html)((Html)this.h1()).text(CountInterceptor.this.name + "(" + InetAddress.getLocalHost().getHostAddress() + ")")).end();
                }
                catch (UnknownHostException e) {
                    log.error("Cannot get address of localhost.", (Throwable)e);
                }
                ((Html)((Html)this.p()).text("This site is generated by a simple interceptor that counts how often this site was requested.")).end();
                ((Html)((Html)this.p()).text("Request count: " + CountInterceptor.this.counter)).end();
                this.endAll();
                this.done();
            }
        };
        return writer.toString();
    }

    @Override
    public String getDisplayName() {
        return "counter: " + super.getDisplayName();
    }

    @Override
    @MCAttribute(attributeName="name")
    @Required
    public void setDisplayName(String name) {
        if (name.startsWith("Counter: ")) {
            super.setDisplayName(name.substring(9));
        } else {
            super.setDisplayName(name);
        }
    }
}

