/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor;

import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exceptions.ProblemDetails;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.openapi.util.UriUtil;
import com.predic8.membrane.core.proxies.AbstractServiceProxy;
import com.predic8.membrane.core.proxies.Proxy;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.EnumSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="dispatching")
public class DispatchingInterceptor
extends AbstractInterceptor {
    private static final Logger log = LoggerFactory.getLogger((String)DispatchingInterceptor.class.getName());

    public DispatchingInterceptor() {
        this.name = "dispatching interceptor";
    }

    @Override
    public Outcome handleRequest(Exchange exc) {
        Proxy proxy = exc.getProxy();
        if (proxy instanceof AbstractServiceProxy) {
            AbstractServiceProxy asp = (AbstractServiceProxy)proxy;
            exc.getDestinations().clear();
            try {
                exc.getDestinations().add(this.getForwardingDestination(exc));
            }
            catch (Exception e) {
                ProblemDetails.internal(this.router.isProduction(), this.getDisplayName()).detail("Could not get forwarding destination to dispatch request").exception(e).buildAndSetResponse(exc);
                return Outcome.ABORT;
            }
            this.setSNIPropertyOnExchange(exc, asp);
            return Outcome.CONTINUE;
        }
        exc.getDestinations().add(exc.getRequest().getUri());
        return Outcome.CONTINUE;
    }

    private void setSNIPropertyOnExchange(Exchange exc, AbstractServiceProxy asp) {
        if (asp.getTargetSSL() == null) {
            return;
        }
        String sni = asp.getTargetSSL().getServerName();
        if (sni == null) {
            return;
        }
        exc.setProperty("membrane.sni.server.name", sni);
    }

    private String getForwardingDestination(Exchange exc) throws Exception {
        String urlResult = this.getAddressFromTargetElement(exc);
        log.debug("destination: {}", (Object)urlResult);
        return urlResult != null ? urlResult : exc.getRequest().getUri();
    }

    protected String getAddressFromTargetElement(Exchange exc) throws MalformedURLException, URISyntaxException {
        AbstractServiceProxy p = (AbstractServiceProxy)exc.getProxy();
        if (p.getTargetURL() != null) {
            if (p.getTargetURL().startsWith("http") && !UriUtil.getPathFromURL(this.router.getUriFactory(), p.getTargetURL()).contains("/")) {
                return p.getTargetURL() + exc.getRequestURI();
            }
            return p.getTargetURL();
        }
        if (p.getTargetHost() != null) {
            return new URL(p.getTargetScheme(), p.getTargetHost(), p.getTargetPort(), exc.getRequest().getUri()).toString();
        }
        return null;
    }

    @Override
    public EnumSet<Interceptor.Flow> getFlow() {
        return Interceptor.Flow.Set.REQUEST_FLOW;
    }
}

