/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor;

import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exceptions.ProblemDetails;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="echo", topLevel=false)
public class EchoInterceptor
extends AbstractInterceptor {
    private static final Logger log = LoggerFactory.getLogger((String)EchoInterceptor.class.getName());

    @Override
    public Outcome handleRequest(Exchange exc) {
        log.debug("Echoing request: {}", (Object)exc.getRequest());
        Response.ResponseBuilder builder = Response.ok();
        try {
            if (!exc.getRequest().isBodyEmpty()) {
                builder.body(exc.getRequest().getBody().getContent());
            } else {
                builder.status(204);
            }
        }
        catch (Exception e) {
            log.error("Could not create echo.", (Throwable)e);
            ProblemDetails.internal(this.router.isProduction(), this.getDisplayName()).detail("Could not create echo!").exception(e).stacktrace(false).buildAndSetResponse(exc);
            return Outcome.ABORT;
        }
        exc.setResponse(builder.header(exc.getRequest().getHeader()).build());
        return Outcome.RETURN;
    }
}

