/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor;

import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.exceptions.ProblemDetails;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowController {
    private static final Logger log = LoggerFactory.getLogger(FlowController.class);
    private final Router router;
    public static final String ABORTION_REASON = "abortionReason";

    public FlowController(Router router) {
        this.router = router;
    }

    public Outcome invokeRequestHandlers(Exchange exchange, List<Interceptor> interceptors) {
        Interceptor.Flow flow = Interceptor.Flow.REQUEST;
        for (int i = 0; i < interceptors.size(); ++i) {
            Interceptor interceptor = interceptors.get(i);
            if (!interceptor.handlesRequests()) continue;
            try {
                Outcome o = interceptor.handleRequest(exchange);
                if (o == Outcome.RETURN) {
                    log.debug("Interceptor returned RETURN. Returning!");
                    flow = Interceptor.Flow.RESPONSE;
                    this.invokeResponseHandlers(exchange, interceptors, i);
                    return Outcome.RETURN;
                }
                if (o != Outcome.ABORT) continue;
                log.debug("Interceptor returned ABORT. Aborting!");
                flow = Interceptor.Flow.ABORT;
                this.invokeAbortHandlers(exchange, interceptors, i);
                return Outcome.ABORT;
            }
            catch (Exception e) {
                String msg = "Aborting! Exception caused in %s during %s %s flow.".formatted(new Object[]{interceptor.getDisplayName(), exchange.getRequest().getUri(), flow});
                log.warn(msg, (Throwable)e);
                ProblemDetails.internal(this.router.isProduction(), interceptor.getDisplayName()).detail(msg).exception(e).buildAndSetResponse(exchange);
                this.invokeAbortHandlers(exchange, interceptors, i);
                return Outcome.ABORT;
            }
        }
        return Outcome.CONTINUE;
    }

    public Outcome invokeResponseHandlers(Exchange exchange, List<Interceptor> interceptors) {
        return this.invokeResponseHandlers(exchange, interceptors, interceptors.size());
    }

    public Outcome invokeResponseHandlers(Exchange exchange, List<Interceptor> interceptors, int pos) {
        boolean aborted = false;
        for (int i = pos - 1; i >= 0; --i) {
            Interceptor interceptor = interceptors.get(i);
            if (!interceptor.handlesResponses()) continue;
            if (!aborted) {
                if (interceptor.handleResponse(exchange) != Outcome.ABORT) continue;
                aborted = true;
                continue;
            }
            interceptor.handleAbort(exchange);
        }
        if (aborted) {
            return Outcome.ABORT;
        }
        return Outcome.CONTINUE;
    }

    public void invokeAbortHandlers(Exchange exchange, List<Interceptor> interceptors) {
        this.invokeAbortHandlers(exchange, interceptors, interceptors.size());
    }

    public void invokeAbortHandlers(Exchange exchange, List<Interceptor> interceptors, int pos) {
        for (int i = pos - 1; i >= 0; --i) {
            try {
                interceptors.get(i).handleAbort(exchange);
                continue;
            }
            catch (Exception e) {
                log.error("Exception handling abort interceptor. Ignoring: Continuing to abort!", (Throwable)e);
            }
        }
    }
}

