/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.TerminateException;
import com.predic8.membrane.core.exceptions.ProblemDetails;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.EmptyBody;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.proxies.AbstractServiceProxy;
import com.predic8.membrane.core.proxies.Proxy;
import com.predic8.membrane.core.transport.http.HttpClient;
import com.predic8.membrane.core.transport.http.client.HttpClientConfiguration;
import com.predic8.membrane.core.util.URLUtil;
import java.io.IOException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="httpClient")
public class HTTPClientInterceptor
extends AbstractInterceptor {
    private static final Logger log = LoggerFactory.getLogger((String)HTTPClientInterceptor.class.getName());
    private static final String PROXIES_HINT = " Maybe the target is only reachable over an HTTP proxy server. Please check proxy settings in conf/proxies.xml.";
    private boolean failOverOn5XX;
    private boolean adjustHostHeader = true;
    private HttpClientConfiguration httpClientConfig;
    private HttpClient hc;

    public HTTPClientInterceptor() {
        this.name = "http client";
        this.setFlow(Interceptor.Flow.Set.REQUEST_FLOW);
    }

    @Override
    public Outcome handleRequest(Exchange exc) {
        try {
            exc.blockRequestIfNeeded();
        }
        catch (TerminateException e) {
            log.error("Could not block request.", (Throwable)e);
        }
        HTTPClientInterceptor.changeMethod(exc);
        try {
            this.hc.call(exc, this.adjustHostHeader, this.failOverOn5XX);
            return Outcome.RETURN;
        }
        catch (ConnectException e) {
            String msg = "Target %s is not reachable.".formatted(this.getDestination(exc));
            log.warn(msg + PROXIES_HINT);
            ProblemDetails.gateway(this.router.isProduction(), this.getDisplayName()).addSubSee("connect").statusCode(502).detail(msg).buildAndSetResponse(exc);
            return Outcome.ABORT;
        }
        catch (SocketTimeoutException e) {
            ProblemDetails.internal(this.router.isProduction(), this.getDisplayName()).addSubSee("socket-timeout").detail("Target %s is not reachable.".formatted(exc.getDestinations())).buildAndSetResponse(exc);
            return Outcome.ABORT;
        }
        catch (UnknownHostException e) {
            String msg = "Target host %s of API %s is unknown. DNS was unable to resolve host name.".formatted(URLUtil.getHost(this.getDestination(exc)), exc.getProxy().getName());
            log.warn(msg + PROXIES_HINT);
            ProblemDetails.gateway(this.router.isProduction(), this.getDisplayName()).addSubSee("unknown-host").statusCode(502).detail(msg).buildAndSetResponse(exc);
            return Outcome.ABORT;
        }
        catch (MalformedURLException e) {
            log.info("Malformed URL. Requested path is: {} {}", (Object)exc.getRequest().getUri(), (Object)e.getMessage());
            log.debug("", (Throwable)e);
            ProblemDetails.user(this.router.isProduction(), this.getDisplayName()).title("Request path or 'Host' header is malformed").addSubSee("malformed-url").exception(e).internal("proxy", exc.getProxy().getName()).internal("url", exc.getRequest().getUri()).buildAndSetResponse(exc);
            return Outcome.ABORT;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            ProblemDetails.internal(this.router.isProduction(), this.getDisplayName()).exception(e).internal("proxy", exc.getProxy().getName()).buildAndSetResponse(exc);
            return Outcome.ABORT;
        }
    }

    private static void changeMethod(Exchange exc) {
        AbstractServiceProxy asp;
        Proxy proxy = exc.getProxy();
        if (!(proxy instanceof AbstractServiceProxy) || (asp = (AbstractServiceProxy)proxy).getTarget() == null) {
            return;
        }
        String newMethod = asp.getTarget().getMethod();
        if (newMethod == null || newMethod.equalsIgnoreCase(exc.getRequest().getMethod())) {
            return;
        }
        log.debug("Changing method from {} to {}", (Object)exc.getRequest().getMethod(), (Object)newMethod);
        exc.getRequest().setMethod(newMethod);
        if (newMethod.equalsIgnoreCase("GET")) {
            HTTPClientInterceptor.handleBodyContentWhenChangingToGET(exc);
        }
    }

    private static void handleBodyContentWhenChangingToGET(Exchange exc) {
        Request req = exc.getRequest();
        try {
            req.readBody();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        req.setBody(new EmptyBody());
        req.getHeader().removeFields("Content-Length");
        req.getHeader().removeFields("Content-Type");
        req.getHeader().removeFields("Content-Encoding");
    }

    private String getDestination(Exchange exc) {
        return exc.getDestinations().getFirst();
    }

    @Override
    public void init() {
        super.init();
        this.hc = this.router.getHttpClientFactory().createClient(this.httpClientConfig);
        this.hc.setStreamPumpStats(this.getRouter().getStatistics().getStreamPumpStats());
    }

    public boolean isFailOverOn5XX() {
        return this.failOverOn5XX;
    }

    @MCAttribute
    public void setFailOverOn5XX(boolean failOverOn5XX) {
        this.failOverOn5XX = failOverOn5XX;
    }

    public boolean isAdjustHostHeader() {
        return this.adjustHostHeader;
    }

    @MCAttribute
    public void setAdjustHostHeader(boolean adjustHostHeader) {
        this.adjustHostHeader = adjustHostHeader;
    }

    public HttpClientConfiguration getHttpClientConfig() {
        return this.httpClientConfig;
    }

    @MCChildElement
    public void setHttpClientConfig(HttpClientConfiguration httpClientConfig) {
        this.httpClientConfig = httpClientConfig;
    }
}

