/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor;

import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exceptions.ProblemDetails;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.RuleMatchingInterceptor;
import com.predic8.membrane.core.proxies.AbstractServiceProxy;
import com.predic8.membrane.core.proxies.Proxy;
import com.predic8.membrane.core.util.URLUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="internalRouting")
public class InternalRoutingInterceptor
extends AbstractInterceptor {
    private static final Logger log = LoggerFactory.getLogger((String)InternalRoutingInterceptor.class.getName());
    public static final String REVERSE_INTERCEPTOR_LIST = "membrane.routing.back.interceptors";

    @Override
    public Outcome handleRequest(Exchange exchange) {
        Outcome outcome;
        if (!this.isTargetInternal(exchange)) {
            return Outcome.CONTINUE;
        }
        Proxy currentProxy = exchange.getProxy();
        try {
            outcome = this.routeService(exchange);
            if (outcome == Outcome.RETURN) {
                outcome = this.getFlowController().invokeResponseHandlers(exchange, InternalRoutingInterceptor.getBackInterceptors(exchange));
                if (outcome == Outcome.CONTINUE) {
                    outcome = Outcome.RETURN;
                }
            } else if (outcome == Outcome.ABORT) {
                this.handleAbort(exchange);
            }
        }
        catch (Exception e) {
            String detail = "Could not invoke request handler for internal route.";
            log.error(detail, (Throwable)e);
            ProblemDetails.internal(this.router.isProduction(), this.getDisplayName()).flow(Interceptor.Flow.REQUEST).detail(detail).exception(e).buildAndSetResponse(exchange);
            return Outcome.ABORT;
        }
        exchange.setProxy(currentProxy);
        return outcome;
    }

    @Override
    public void handleAbort(Exchange exc) {
        this.getFlowController().invokeAbortHandlers(exc, InternalRoutingInterceptor.getBackInterceptors(exc));
    }

    @Override
    public Outcome handleResponse(Exchange exc) {
        try {
            return this.getFlowController().invokeResponseHandlers(exc, InternalRoutingInterceptor.getBackInterceptors(exc));
        }
        catch (Exception e) {
            String detail = "Could not invoke response handler for internal route.";
            log.error(detail, (Throwable)e);
            ProblemDetails.internal(this.router.isProduction(), this.getDisplayName()).flow(Interceptor.Flow.RESPONSE).detail(detail).exception(e).buildAndSetResponse(exc);
            return Outcome.ABORT;
        }
    }

    @Nullable
    private Outcome routeService(Exchange exchange) throws Exception {
        AbstractServiceProxy service = this.getRuleByDest(exchange);
        RuleMatchingInterceptor.assignRule(exchange, service);
        InternalRoutingInterceptor.updateRequestPath(exchange);
        Outcome outcome = InternalRoutingInterceptor.callInterceptors(exchange, service.getInterceptors());
        exchange.getDestinations().clear();
        exchange.getDestinations().add(InternalRoutingInterceptor.getTargetAsUri(exchange, service));
        if (outcome == Outcome.ABORT || outcome == Outcome.RETURN) {
            return outcome;
        }
        if (this.isTargetInternal(exchange)) {
            return this.routeService(exchange);
        }
        return outcome;
    }

    @NotNull
    private static Outcome callInterceptors(Exchange exchange, List<Interceptor> interceptors) {
        List<Interceptor> backInterceptors = InternalRoutingInterceptor.getBackInterceptors(exchange);
        for (Interceptor interceptor : interceptors) {
            if (!interceptor.handlesRequests()) {
                backInterceptors.add(interceptor);
                continue;
            }
            try {
                Outcome o = interceptor.handleRequest(exchange);
                if (o == Outcome.RETURN || o == Outcome.ABORT) {
                    return o;
                }
                backInterceptors.add(interceptor);
            }
            catch (Throwable t) {
                log.debug("Error from interceptor {}. Aborting. Reason {}.", (Object)interceptor.getClass().getSimpleName(), (Object)t.getMessage());
                return Outcome.ABORT;
            }
        }
        return Outcome.CONTINUE;
    }

    private boolean isTargetInternal(Exchange exc) {
        return exc.getDestinations().getFirst().startsWith("internal:");
    }

    private AbstractServiceProxy getRuleByDest(Exchange exchange) {
        Proxy proxy = this.router.getRuleManager().getRuleByName(URLUtil.getHost(exchange.getDestinations().getFirst()), Proxy.class);
        if (proxy == null) {
            throw new RuntimeException("No api found for destination " + exchange.getDestinations().getFirst());
        }
        if (proxy instanceof AbstractServiceProxy) {
            AbstractServiceProxy sp = (AbstractServiceProxy)proxy;
            return sp;
        }
        throw new RuntimeException("Not a service proxy: " + proxy.getClass().getSimpleName());
    }

    private static List<Interceptor> getBackInterceptors(Exchange exc) {
        Object o = exc.getProperty(REVERSE_INTERCEPTOR_LIST);
        if (o != null) {
            return (List)o;
        }
        ArrayList<Interceptor> l = new ArrayList<Interceptor>();
        exc.setProperty(REVERSE_INTERCEPTOR_LIST, l);
        return l;
    }

    private static void updateRequestPath(Exchange exchange) throws URISyntaxException {
        String path = new URI(exchange.getDestinations().getFirst()).getPath();
        if (path != null && !path.isEmpty()) {
            exchange.getRequest().setUri(path);
        }
    }

    @Nullable
    private static String getTargetAsUri(Exchange exchange, AbstractServiceProxy service) {
        if (service.getTargetURL() != null) {
            return service.getTargetURL();
        }
        if (service.getTarget().getHost() != null) {
            return service.getTargetScheme() + "://" + service.getTarget().getHost() + ":" + service.getTarget().getPort() + exchange.getRequest().getUri();
        }
        return "/";
    }

    @Override
    public String getDisplayName() {
        return "Internal routing";
    }
}

