/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.annot.Required;
import com.predic8.membrane.core.exceptions.ProblemDetails;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Header;
import com.predic8.membrane.core.http.HeaderField;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="regExReplacer")
public class RegExReplaceInterceptor
extends AbstractInterceptor {
    private static final Logger log = LoggerFactory.getLogger((String)RegExReplaceInterceptor.class.getName());
    private String regex;
    private String replace;
    private TargetType target = TargetType.BODY;

    public RegExReplaceInterceptor() {
        this.name = "regex replacer";
    }

    @Override
    public String getShortDescription() {
        return "Replaces strings in message header or body using regular expressions.";
    }

    @Override
    public Outcome handleRequest(Exchange exc) {
        return this.handleInternal(exc, exc.getRequest());
    }

    @Override
    public Outcome handleResponse(Exchange exc) {
        return this.handleInternal(exc, exc.getResponse());
    }

    private Outcome handleInternal(Exchange exc, Message message) {
        if (this.target == TargetType.HEADER) {
            this.replaceHeader(message.getHeader());
            return Outcome.CONTINUE;
        }
        try {
            this.replaceBody(message);
        }
        catch (Exception e) {
            ProblemDetails.internal(this.router.isProduction(), this.getDisplayName()).detail("Could not replace body!").exception(e).buildAndSetResponse(exc);
            return Outcome.ABORT;
        }
        return Outcome.CONTINUE;
    }

    private void replaceHeader(Header header) {
        for (HeaderField hf : header.getAllHeaderFields()) {
            hf.setValue(hf.getValue().replaceAll(this.regex, this.replace));
        }
    }

    private void replaceBody(Message res) throws Exception {
        if (res.getHeader().isBinaryContentType()) {
            return;
        }
        log.debug("pattern: {}", (Object)this.regex);
        log.debug("replacement: {}", (Object)this.replace);
        res.setBodyContent(res.getBodyAsStringDecoded().replaceAll(this.regex, this.replace).getBytes(res.getCharset()));
        res.getHeader().removeFields("Content-Encoding");
    }

    public String getRegex() {
        return this.regex;
    }

    @MCAttribute
    @Required
    public void setRegex(String regex) {
        this.regex = regex;
    }

    public String getReplace() {
        return this.replace;
    }

    @MCAttribute
    @Required
    public void setReplace(String replace) {
        this.replace = replace;
    }

    public TargetType getTarget() {
        return this.target;
    }

    @MCAttribute
    public void setTarget(TargetType target) {
        this.target = target;
    }

    public static enum TargetType {
        BODY,
        HEADER;

    }
}

