/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor;

import com.googlecode.jatl.Html;
import com.predic8.membrane.core.exceptions.ProblemDetails;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.proxies.ProxyRule;
import com.predic8.membrane.core.ws.relocator.Relocator;
import java.io.StringWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RelocatingInterceptor
extends AbstractInterceptor {
    private static final Logger log = LoggerFactory.getLogger((String)RelocatingInterceptor.class.getName());
    protected String host;
    protected String protocol;
    protected String port;
    protected Relocator.PathRewriter pathRewriter;

    @Override
    public Outcome handleResponse(Exchange exc) {
        if (exc.getProxy() instanceof ProxyRule) {
            log.debug("{} ProxyRule found: No relocating done!", (Object)this.name);
            return Outcome.CONTINUE;
        }
        if (!this.wasGetRequest(exc)) {
            log.debug("{} HTTP method wasn't GET: No relocating done!", (Object)this.name);
            return Outcome.CONTINUE;
        }
        if (!this.hasContent(exc)) {
            log.debug("{} No Content: No relocating done!", (Object)this.name);
            return Outcome.CONTINUE;
        }
        if (!exc.getResponse().isXML()) {
            log.debug("{} Body contains no XML: No relocating done!", (Object)this.name);
            return Outcome.CONTINUE;
        }
        try {
            this.rewrite(exc);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            ProblemDetails.internal(this.router.isProduction(), this.getDisplayName()).detail("Error rewriting URI").topLevel("URI", exc.getRequestURI()).exception(e).buildAndSetResponse(exc);
            return Outcome.ABORT;
        }
        return Outcome.CONTINUE;
    }

    abstract void rewrite(Exchange var1) throws Exception;

    private boolean hasContent(Exchange exc) {
        return exc.getResponse().getHeader().getContentType() != null;
    }

    private boolean wasGetRequest(Exchange exc) {
        return "GET".equals(exc.getRequest().getMethod());
    }

    protected int getLocationPort(Exchange exc) {
        if ("".equals(this.port)) {
            return -1;
        }
        if (this.port != null) {
            return Integer.parseInt(this.port);
        }
        return exc.getHandler().getLocalPort();
    }

    protected String getLocationHost(Exchange exc) {
        if (this.host != null) {
            return this.host;
        }
        String locHost = exc.getOriginalHostHeaderHost();
        log.debug("host {}", (Object)locHost);
        if (locHost == null) {
            return "localhost";
        }
        return locHost;
    }

    protected String getLocationProtocol() {
        if (this.protocol != null) {
            return this.protocol;
        }
        return "http";
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setPathRewriter(Relocator.PathRewriter pathRewriter) {
        this.pathRewriter = pathRewriter;
    }

    @Override
    public String getLongDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getShortDescription());
        sb.append("<br/>");
        sb.append("The protocol, host and port of the incoming request will be used for the substitution");
        if (this.protocol != null || this.port != null || this.host != null) {
            sb.append(" except the following fixed values:");
            StringWriter sw = new StringWriter();
            new Html(sw){
                {
                    this.table();
                    this.thead();
                    this.tr();
                    ((Html)((Html)this.th()).text("Part")).end();
                    ((Html)((Html)this.th()).text("Value")).end();
                    this.end();
                    this.end();
                    this.tbody();
                    if (RelocatingInterceptor.this.protocol != null) {
                        this.tr();
                        ((Html)((Html)this.td()).text("Protocol")).end();
                        ((Html)((Html)this.td()).text(RelocatingInterceptor.this.protocol)).end();
                        this.end();
                    }
                    if (RelocatingInterceptor.this.host != null) {
                        this.tr();
                        ((Html)((Html)this.td()).text("Host")).end();
                        ((Html)((Html)this.td()).text(RelocatingInterceptor.this.host)).end();
                        this.end();
                    }
                    if (RelocatingInterceptor.this.port != null) {
                        this.tr();
                        ((Html)((Html)this.td()).text("Port")).end();
                        ((Html)((Html)this.td()).text(RelocatingInterceptor.this.port)).end();
                        this.end();
                    }
                    this.end();
                    this.end();
                }
            };
            sb.append(sw);
        } else {
            sb.append(".");
        }
        return sb.toString();
    }
}

