/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exceptions.ProblemDetails;
import com.predic8.membrane.core.exchange.AbstractExchange;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Header;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.proxies.AbstractServiceProxy;
import com.predic8.membrane.core.proxies.NullProxy;
import com.predic8.membrane.core.proxies.Proxy;
import com.predic8.membrane.core.proxies.SSLableProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="ruleMatching")
public class RuleMatchingInterceptor
extends AbstractInterceptor {
    private static final Logger log = LoggerFactory.getLogger((String)RuleMatchingInterceptor.class.getName());
    private boolean xForwardedForEnabled = true;
    private int maxXForwardedForHeaders = 20;

    public RuleMatchingInterceptor() {
        this.name = "rule matching interceptor";
        this.setFlow(Interceptor.Flow.Set.REQUEST_FLOW);
    }

    @Override
    public Outcome handleRequest(Exchange exc) {
        if (exc.getProxy() != null) {
            return Outcome.CONTINUE;
        }
        Proxy proxy = this.getRule(exc);
        RuleMatchingInterceptor.assignRule(exc, proxy);
        if (proxy instanceof NullProxy) {
            ProblemDetails.user(this.router.isProduction(), "routing").statusCode(404).title("Wrong path or method").detail("This request was not accepted by Membrane. Please check HTTP method and path.").topLevel("method", exc.getRequest().getMethod()).topLevel("uri", exc.getRequest().getUri()).buildAndSetResponse(exc);
            return Outcome.ABORT;
        }
        if (this.xForwardedForEnabled && proxy instanceof AbstractServiceProxy) {
            this.insertXForwardedFor(exc);
        }
        return Outcome.CONTINUE;
    }

    public static void assignRule(Exchange exc, Proxy proxy) {
        exc.setProxy(proxy);
        if (!(proxy instanceof SSLableProxy)) {
            return;
        }
        SSLableProxy sp = (SSLableProxy)proxy;
        if (sp.isOutboundSSL()) {
            exc.setProperty("membrane.ssl.context", sp.getSslOutboundContext());
        }
    }

    private Proxy getRule(Exchange exc) {
        return this.router.getRuleManager().getMatchingRule(exc);
    }

    private void insertXForwardedFor(AbstractExchange exc) {
        Header h = exc.getRequest().getHeader();
        if (h.getNumberOf("X-Forwarded-For") > this.maxXForwardedForHeaders) {
            Request r = exc.getRequest();
            throw new RuntimeException("Request caused X-Forwarded-For flood: " + r.getStartLine() + String.valueOf(r.getHeader()));
        }
        h.setXForwardedFor(this.getXForwardedForHeaderValue(exc));
        if (h.getNumberOf("X-Forwarded-Proto") > this.maxXForwardedForHeaders) {
            Request r = exc.getRequest();
            throw new RuntimeException("Request caused X-Forwarded-Proto flood: " + r.getStartLine() + r.getHeader().toString());
        }
        h.setXForwardedProto(this.getXForwardedProtoHeaderValue(exc));
        if (h.getNumberOf("X-Forwarded-Host") > this.maxXForwardedForHeaders) {
            Request r = exc.getRequest();
            throw new RuntimeException("Request caused X-Forwarded-Host flood: " + r.getStartLine() + r.getHeader().toString());
        }
        h.setXForwardedHost(this.getXForwardedHostHeaderValue(exc));
    }

    private String getXForwardedHostHeaderValue(AbstractExchange exc) {
        if (this.getXForwardedHost(exc) != null) {
            return this.getXForwardedHost(exc) + ", " + exc.getRequest().getHeader().getHost();
        }
        return exc.getRequest().getHeader().getHost();
    }

    private String getXForwardedHost(AbstractExchange exc) {
        return exc.getRequest().getHeader().getXForwardedHost();
    }

    private String getXForwardedForHeaderValue(AbstractExchange exc) {
        if (this.getXForwardedFor(exc) != null) {
            return this.getXForwardedFor(exc) + ", " + exc.getRemoteAddrIp();
        }
        return exc.getRemoteAddrIp();
    }

    private String getXForwardedProtoHeaderValue(AbstractExchange exc) {
        if (this.getXForwardedProto(exc) != null) {
            return this.getXForwardedProto(exc);
        }
        return exc.getProxy().getProtocol();
    }

    private String getXForwardedFor(AbstractExchange exc) {
        return exc.getRequest().getHeader().getXForwardedFor();
    }

    private String getXForwardedProto(AbstractExchange exc) {
        return exc.getRequest().getHeader().getXForwardedProto();
    }

    @Override
    public String toString() {
        return "RuleMatchingInterceptor";
    }

    public boolean isxForwardedForEnabled() {
        return this.xForwardedForEnabled;
    }

    @MCAttribute
    public void setxForwardedForEnabled(boolean xForwardedForEnabled) {
        this.xForwardedForEnabled = xForwardedForEnabled;
    }

    public int getMaxXForwardedForHeaders() {
        return this.maxXForwardedForHeaders;
    }

    @MCAttribute
    public void setMaxXForwardedForHeaders(int maxXForwardedForHeaders) {
        this.maxXForwardedForHeaders = maxXForwardedForHeaders;
    }
}

