/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="throttle")
public class ThrottleInterceptor
extends AbstractInterceptor {
    private static final Logger log = LoggerFactory.getLogger((String)ThrottleInterceptor.class.getName());
    private long delay = 0L;
    private int maxThreads = 0;
    private int threads = 0;
    private int busyDelay = 0;

    public ThrottleInterceptor() {
        this.name = "throttle";
    }

    @Override
    public Outcome handleRequest(Exchange exc) {
        if (this.delay > 0L) {
            log.debug("delaying for {} ms", (Object)this.delay);
            this.sleep(this.delay);
        }
        if (this.maxThreads > 0 && this.threads >= this.maxThreads) {
            log.debug("Max thread limit of {} reached. Waiting {}ms", (Object)this.maxThreads, (Object)this.busyDelay);
            this.sleep(this.busyDelay);
            if (this.threads >= this.maxThreads) {
                log.info("Max thread limit of {} reached. Server Busy.", (Object)this.maxThreads);
                exc.setResponse(Response.serviceUnavailable("Server busy.").build());
                return Outcome.ABORT;
            }
        }
        this.increaseThreads();
        log.debug("thread count increased: {}", (Object)this.threads);
        return Outcome.CONTINUE;
    }

    private void sleep(long delay) {
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public Outcome handleResponse(Exchange exc) {
        this.decreaseThreads();
        log.debug("thread count decreased: {}", (Object)this.threads);
        return Outcome.CONTINUE;
    }

    @Override
    public void handleAbort(Exchange exchange) {
        this.decreaseThreads();
        log.debug("thread count decreased: {}", (Object)this.threads);
    }

    private synchronized void decreaseThreads() {
        --this.threads;
    }

    private synchronized void increaseThreads() {
        ++this.threads;
    }

    public long getDelay() {
        return this.delay;
    }

    @MCAttribute
    public void setDelay(long delay) {
        this.delay = delay;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    @MCAttribute
    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    public int getBusyDelay() {
        return this.busyDelay;
    }

    @MCAttribute
    public void setBusyDelay(int busyDelay) {
        this.busyDelay = busyDelay;
    }

    @Override
    public String getShortDescription() {
        if (this.delay > 0L || this.maxThreads > 0) {
            return "Throttles the rate of incoming requests.";
        }
        return "Not configured.";
    }

    @Override
    public String getLongDescription() {
        StringBuilder sb = new StringBuilder();
        if (this.delay > 0L) {
            sb.append("Delays requests by " + String.format("%.1f", (double)this.delay / 1000.0) + " seconds.");
        }
        if (this.maxThreads > 0) {
            sb.append("Only allows " + this.maxThreads + " concurrent requests.");
            if (this.busyDelay > 0) {
                sb.append("The server waits at most " + String.format("%.1f", (double)this.busyDelay / 1000.0) + " seconds for enough running requests to terminate, returning an error if the server is still busy after the timeout.");
            }
        }
        return sb.toString();
    }
}

