/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor;

import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.util.URIUtil;

@MCElement(name="urlNormalizer")
public class URLNormalizerInterceptor
extends AbstractInterceptor {
    public URLNormalizerInterceptor() {
        this.name = "url path normalizer";
    }

    @Override
    public String getShortDescription() {
        return "Replaces /./ in the request URI's path by /.\n\ne.g.\nhttp//api.predic8.de/foo/./bar\n\nto:\n\nhttp//api.predic8.de/foo/bar\n";
    }

    @Override
    public Outcome handleRequest(Exchange exc) {
        exc.getRequest().setUri(URIUtil.normalizeSingleDot(exc.getRequestURI()));
        return Outcome.CONTINUE;
    }
}

